/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.function.ToIntFunction;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionException;
import net.sourceforge.pmd.lang.rule.xpath.internal.XPathElementToNodeHelper;

public final class CoordinateXPathFunction
extends XPathFunctionDefinition {
    public static final CoordinateXPathFunction START_LINE = new CoordinateXPathFunction("startLine", Node::getBeginLine);
    public static final CoordinateXPathFunction END_LINE = new CoordinateXPathFunction("endLine", Node::getEndLine);
    public static final CoordinateXPathFunction START_COLUMN = new CoordinateXPathFunction("startColumn", Node::getBeginColumn);
    public static final CoordinateXPathFunction END_COLUMN = new CoordinateXPathFunction("endColumn", Node::getEndColumn);
    private static final XPathFunctionDefinition.Type[] A_SINGLE_ELEMENT = new XPathFunctionDefinition.Type[]{XPathFunctionDefinition.Type.SINGLE_ELEMENT};
    public static final String PMD_NODE_USER_DATA = "pmd.node";
    private final ToIntFunction<Node> getter;

    private CoordinateXPathFunction(String localName, ToIntFunction<Node> getter) {
        super(localName);
        this.getter = getter;
    }

    @Override
    public XPathFunctionDefinition.Type[] getArgumentTypes() {
        return A_SINGLE_ELEMENT;
    }

    @Override
    public XPathFunctionDefinition.Type getResultType() {
        return XPathFunctionDefinition.Type.SINGLE_INTEGER;
    }

    @Override
    public XPathFunctionDefinition.FunctionCall makeCallExpression() {
        return (contextNode, arguments) -> {
            Node node = XPathElementToNodeHelper.itemToNode(arguments[0]);
            if (node == null) {
                throw new XPathFunctionException("Cannot call function '" + this.getQName().getLocalPart() + "' on argument " + arguments[0]);
            }
            return this.getter.applyAsInt(node);
        };
    }
}

