/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.internal.LatticeRelation;
import net.sourceforge.pmd.lang.rule.internal.TopoOrder;
import net.sourceforge.pmd.util.IteratorUtil;

public class TreeIndex {
    private final LatticeRelation<Class<?>, Node, Iterable<Node>> byClass;
    private final Set<String> interestingNames;
    private final Map<String, List<Node>> byName;

    public TreeIndex(Set<String> namesToIndex, Set<Class<? extends Node>> classesToIndex) {
        this.byClass = new LatticeRelation(TopoOrder.TYPE_HIERARCHY_ORDERING, classesToIndex, Class::getSimpleName, Collectors.toSet());
        this.interestingNames = namesToIndex;
        this.byName = new HashMap<String, List<Node>>();
    }

    void indexNode(Node n) {
        if (this.interestingNames.contains(n.getXPathNodeName())) {
            this.byName.computeIfAbsent(n.getXPathNodeName(), k -> new ArrayList()).add(n);
        }
        this.byClass.put(n.getClass(), n);
    }

    void reset() {
        this.byClass.clearValues();
        this.byName.clear();
    }

    Iterator<Node> getByName(String n) {
        return this.byName.getOrDefault(n, Collections.emptyList()).iterator();
    }

    Iterator<Node> getByClass(Class<? extends Node> n) {
        return this.byClass.get(n).iterator();
    }

    public Iterator<Node> getByName(Collection<String> n) {
        return IteratorUtil.flatMap(n.iterator(), this::getByName);
    }

    public Iterator<Node> getByClass(Collection<? extends Class<? extends Node>> n) {
        return IteratorUtil.flatMap(n.iterator(), this::getByClass);
    }
}

