/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.internal.TargetSelectorInternal;
import net.sourceforge.pmd.lang.rule.internal.TreeIndex;
import net.sourceforge.pmd.util.CollectionUtil;

public abstract class RuleTargetSelector
extends TargetSelectorInternal {
    RuleTargetSelector() {
    }

    public static RuleTargetSelector forXPathNames(Collection<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("Cannot visit zero nodes");
        }
        return new StringRulechainVisits(names);
    }

    public static RuleTargetSelector forTypes(Collection<Class<? extends Node>> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Cannot visit zero types");
        }
        return new ClassRulechainVisits(types);
    }

    @SafeVarargs
    public static RuleTargetSelector forTypes(Class<? extends Node> first, Class<? extends Node> ... types) {
        return RuleTargetSelector.forTypes(CollectionUtil.listOf(first, types));
    }

    public static RuleTargetSelector forRootOnly() {
        return ClassRulechainVisits.ROOT_ONLY;
    }

    private static final class ClassRulechainVisits
    extends RuleTargetSelector {
        public static final RuleTargetSelector ROOT_ONLY = new ClassRulechainVisits(Collections.singleton(RootNode.class));
        private final Set<Class<? extends Node>> visits;

        ClassRulechainVisits(Collection<Class<? extends Node>> visits) {
            if (visits.contains(null)) {
                throw new NullPointerException("Null element in class visits " + visits);
            }
            this.visits = new LinkedHashSet<Class<? extends Node>>(visits);
        }

        @Override
        protected void prepare(TargetSelectorInternal.ApplicatorBuilder builder) {
            builder.registerClasses(this.visits);
        }

        @Override
        protected Iterator<? extends Node> getVisitedNodes(TreeIndex index) {
            return index.getByClass(this.visits);
        }

        public String toString() {
            return "ClassVisits" + this.visits;
        }
    }

    private static final class StringRulechainVisits
    extends RuleTargetSelector {
        private final Set<String> visits;

        StringRulechainVisits(Collection<String> visits) {
            this.visits = new HashSet<String>(visits);
        }

        @Override
        protected void prepare(TargetSelectorInternal.ApplicatorBuilder builder) {
            builder.registerXPathNames(this.visits);
        }

        @Override
        protected Iterator<? extends Node> getVisitedNodes(TreeIndex index) {
            return index.getByName(this.visits);
        }

        public String toString() {
            return "XPathNameVisits" + this.visits;
        }
    }
}

