/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.DataMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Metric<N extends Node, R extends Number>
extends DataMap.DataKey<Metric<N, R>, R> {
    public String displayName();

    public List<String> nameAliases();

    default public boolean supports(Node node) {
        return this.castIfSupported(node) != null;
    }

    public @Nullable N castIfSupported(@NonNull Node var1);

    public R computeFor(N var1, MetricOptions var2);

    public static <T extends Node, R extends Number> Metric<T, R> of(final BiFunction<? super T, MetricOptions, ? extends R> compute, final Function<? super Node, ? extends @Nullable T> cast, final @NonNull String fullName, String ... aliases) {
        AssertionUtil.requireParamNotNull("compute", compute);
        AssertionUtil.requireParamNotNull("cast", cast);
        AssertionUtil.requireParamNotNull("fullName", fullName);
        AssertionUtil.requireParamNotNull("aliases", aliases);
        final List<String> allNames = CollectionUtil.listOf(fullName, aliases);
        return new Metric<T, R>(){

            @Override
            public String displayName() {
                return fullName;
            }

            @Override
            public List<String> nameAliases() {
                return allNames;
            }

            @Override
            public @Nullable T castIfSupported(@NonNull Node node) {
                return (Node)cast.apply(node);
            }

            @Override
            public R computeFor(T node, MetricOptions options) {
                return (Number)compute.apply(node, options);
            }
        };
    }

    public static <N extends Node, R extends Number> @Nullable R compute(Metric<N, R> metric, Node node, MetricOptions options) {
        N n = metric.castIfSupported(node);
        if (n != null) {
            return metric.computeFor(n, options);
        }
        return null;
    }
}

