/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessor;
import net.sourceforge.pmd.lang.impl.PmdRunnable;
import net.sourceforge.pmd.lang.impl.PmdThreadFactory;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.slf4j.event.Level;

final class MultiThreadProcessor
extends AbstractPMDProcessor {
    private final ExecutorService executor;
    private final List<Future<?>> futureList;

    MultiThreadProcessor(LanguageProcessor.AnalysisTask task) {
        super(task);
        int threadCount = task.getThreadCount();
        if (threadCount == 1) {
            task.getMessageReporter().log(Level.DEBUG, "Using 1 thread for analysis", new Object[0]);
        } else {
            task.getMessageReporter().log(Level.DEBUG, "Using {0} threads for analysis", threadCount);
        }
        this.executor = Executors.newFixedThreadPool(threadCount, new PmdThreadFactory());
        this.futureList = new LinkedList();
    }

    @Override
    public void processFiles() {
        final ThreadLocal<RuleSets> ruleSetCopy = ThreadLocal.withInitial(() -> {
            RuleSets copy = new RuleSets(this.task.getRulesets());
            copy.initializeRules(this.task.getLpRegistry(), PmdReporter.quiet());
            return copy;
        });
        for (TextFile textFile : this.task.getFiles()) {
            this.futureList.add(this.executor.submit(new PmdRunnable(textFile, this.task){

                @Override
                protected RuleSets getRulesets() {
                    return (RuleSets)ruleSetCopy.get();
                }
            }));
        }
    }

    @Override
    public void close() {
        try {
            block9: {
                try {
                    for (Future<?> task : this.futureList) {
                        task.get();
                    }
                }
                catch (ExecutionException e) {
                    this.task.getMessageReporter().error("Unknown error occurred while executing a PmdRunnable: {0}", e.getCause().toString(), e.getCause());
                    if (!(e.getCause() instanceof Error)) break block9;
                    throw (Error)e.getCause();
                }
            }
            this.executor.shutdown();
            while (!this.executor.awaitTermination(10L, TimeUnit.HOURS)) {
                Thread.yield();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.executor.shutdownNow();
        }
    }
}

