/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.util.Comparator;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TextRegion
implements Comparable<TextRegion> {
    private static final Comparator<TextRegion> COMPARATOR = Comparator.comparingInt(TextRegion::getStartOffset).thenComparingInt(TextRegion::getLength);
    private final int startOffset;
    private final int length;

    private TextRegion(int startOffset, int length) {
        this.startOffset = startOffset;
        this.length = length;
        assert (startOffset >= 0 && length >= 0) : "Invalid region " + this;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean contains(int offset) {
        return this.getStartOffset() <= offset && offset < this.getEndOffset();
    }

    public boolean contains(TextRegion other) {
        return this.getStartOffset() <= other.getStartOffset() && other.getEndOffset() <= this.getEndOffset();
    }

    public boolean overlaps(TextRegion other) {
        TextRegion intersection = TextRegion.intersect(this, other);
        return intersection != null && intersection.getLength() != 0;
    }

    public TextRegion growLeft(int delta) {
        assert (delta + this.length >= 0) : "Left delta " + delta + " would produce a negative length region " + this.parThis();
        assert (this.startOffset - delta >= 0) : "Left delta " + delta + " would produce a region that starts before zero " + this.parThis();
        return new TextRegion(this.startOffset - delta, delta + this.length);
    }

    public TextRegion growRight(int delta) {
        assert (delta + this.length >= 0) : "Right delta " + delta + " would produce a negative length region " + this.parThis();
        return new TextRegion(this.startOffset, delta + this.length);
    }

    public static @Nullable TextRegion intersect(TextRegion r1, TextRegion r2) {
        int end;
        int start = Math.max(r1.getStartOffset(), r2.getStartOffset());
        return start <= (end = Math.min(r1.getEndOffset(), r2.getEndOffset())) ? TextRegion.fromBothOffsets(start, end) : null;
    }

    public static TextRegion union(TextRegion r1, TextRegion r2) {
        if (r1.equals(r2)) {
            return r1;
        }
        int start = Math.min(r1.getStartOffset(), r2.getStartOffset());
        int end = Math.max(r1.getEndOffset(), r2.getEndOffset());
        return TextRegion.fromBothOffsets(start, end);
    }

    public static TextRegion fromOffsetLength(int startOffset, int length) {
        return new TextRegion(startOffset, length);
    }

    public static TextRegion fromBothOffsets(int startOffset, int endOffset) {
        return new TextRegion(startOffset, endOffset - startOffset);
    }

    public static TextRegion caretAt(int startOffset) {
        return new TextRegion(startOffset, 0);
    }

    public static boolean isValidRegion(int startOffset, int endOffset, TextDocument doc) {
        assert (startOffset >= 0) : "Negative start offset: " + startOffset;
        assert (endOffset >= 0) : "Negative end offset: " + endOffset;
        assert (startOffset <= endOffset) : "Start and end offset are not ordered: " + startOffset + " > " + endOffset;
        assert (endOffset <= doc.getLength()) : "End offset " + endOffset + " out of range for doc of length " + doc.getLength();
        return true;
    }

    private String parThis() {
        return "(" + this + ")";
    }

    @Override
    public int compareTo(@NonNull TextRegion o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "Region(start=" + this.startOffset + ", len=" + this.length + ", end=" + this.getEndOffset() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextRegion)) {
            return false;
        }
        TextRegion that = (TextRegion)o;
        return this.startOffset == that.getStartOffset() && this.length == that.getLength();
    }

    public int hashCode() {
        return this.startOffset * 31 + this.length;
    }
}

