/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.NioTextFile;
import net.sourceforge.pmd.lang.document.ReaderTextFile;
import net.sourceforge.pmd.lang.document.StringTextFile;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TextFileBuilder {
    protected final LanguageVersion languageVersion;
    protected FileId parentFsId;

    TextFileBuilder(LanguageVersion languageVersion) {
        this.languageVersion = AssertionUtil.requireParamNotNull("language version", languageVersion);
    }

    public TextFileBuilder asReadOnly() {
        return this;
    }

    public TextFileBuilder setParentFsPath(@Nullable FileId fileId) {
        this.parentFsId = fileId;
        return this;
    }

    public abstract TextFile build();

    static class ForReader
    extends TextFileBuilder {
        private final Reader reader;
        private FileId fileId;

        ForReader(LanguageVersion languageVersion, Reader reader, FileId fileId) {
            super(languageVersion);
            this.reader = AssertionUtil.requireParamNotNull("reader", reader);
            this.fileId = AssertionUtil.requireParamNotNull("path ID", fileId);
        }

        @Override
        public TextFileBuilder setParentFsPath(@Nullable FileId fileId) {
            this.fileId = FileId.asChildOf(this.fileId, fileId);
            return super.setParentFsPath(fileId);
        }

        @Override
        public TextFile build() {
            return new ReaderTextFile(this.reader, this.fileId, this.languageVersion);
        }
    }

    static class ForCharSeq
    extends TextFileBuilder {
        private final CharSequence charSequence;
        private FileId fileId;

        ForCharSeq(CharSequence charSequence, FileId fileId, LanguageVersion languageVersion) {
            super(languageVersion);
            this.charSequence = AssertionUtil.requireParamNotNull("charseq", charSequence);
            this.fileId = AssertionUtil.requireParamNotNull("path ID", fileId);
        }

        @Override
        public TextFileBuilder setParentFsPath(@Nullable FileId fileId) {
            this.fileId = FileId.asChildOf(this.fileId, fileId);
            return super.setParentFsPath(fileId);
        }

        @Override
        public TextFile build() {
            return new StringTextFile(this.charSequence, this.fileId, this.languageVersion);
        }
    }

    static class ForNio
    extends TextFileBuilder {
        private final Path path;
        private final Charset charset;
        private boolean readOnly = false;

        ForNio(LanguageVersion languageVersion, Path path, Charset charset) {
            super(languageVersion);
            this.path = AssertionUtil.requireParamNotNull("path", path);
            this.charset = AssertionUtil.requireParamNotNull("charset", charset);
        }

        @Override
        public TextFileBuilder asReadOnly() {
            this.readOnly = true;
            return this;
        }

        @Override
        public TextFile build() {
            return new NioTextFile(this.path, this.parentFsId, this.charset, this.languageVersion, this.readOnly);
        }
    }
}

