/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.FragmentedTextDocument;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;

public final class FragmentedDocBuilder {
    private final Chars mainBuf;
    private final TextDocument original;
    private FragmentedTextDocument.Fragment lastFragment;
    private FragmentedTextDocument.Fragment firstFragment;
    private int curOffInInput;

    public FragmentedDocBuilder(TextDocument original) {
        this.mainBuf = original.getText();
        this.original = original;
    }

    public FileLocation toLocation(int indexInInput) {
        return this.original.toLocation(TextRegion.caretAt(indexInInput));
    }

    public void recordDelta(int startInInput, int endInInput, Chars translation) {
        assert (this.curOffInInput <= startInInput) : "Already moved past " + this.curOffInInput + ", cannot add delta at " + startInInput;
        assert (startInInput <= endInInput) : "Offsets must be ordered";
        assert (translation != null) : "Translation cannot be null";
        int inLength = endInInput - startInInput;
        if (this.firstFragment == null) {
            assert (this.lastFragment == null);
            this.firstFragment = new FragmentedTextDocument.Fragment(null, startInInput, this.mainBuf.slice(0, startInInput));
            this.lastFragment = new FragmentedTextDocument.Fragment(this.firstFragment, inLength, translation);
            this.curOffInInput = endInInput;
            return;
        }
        FragmentedTextDocument.Fragment last = this.lastFragment;
        int prevLen = startInInput - this.curOffInInput;
        if (prevLen != 0) {
            last = new FragmentedTextDocument.Fragment(last, prevLen, this.mainBuf.slice(this.curOffInInput, prevLen));
        }
        this.lastFragment = last = new FragmentedTextDocument.Fragment(last, inLength, translation);
        this.curOffInInput = endInInput;
    }

    public TextDocument build() {
        if (this.firstFragment == null) {
            return this.original;
        }
        if (this.curOffInInput < this.mainBuf.length()) {
            int remLen = this.mainBuf.length() - this.curOffInInput;
            Chars remainder = this.mainBuf.slice(this.curOffInInput, remLen);
            this.lastFragment = new FragmentedTextDocument.Fragment(this.lastFragment, remLen, remainder);
        }
        return new FragmentedTextDocument(this.original, this.firstFragment, this.lastFragment);
    }
}

