/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.ast.internal.AxisStream;
import net.sourceforge.pmd.lang.ast.internal.Filtermap;
import net.sourceforge.pmd.lang.ast.internal.GreedyNStream;
import net.sourceforge.pmd.lang.ast.internal.IteratorBasedNStream;
import net.sourceforge.pmd.lang.ast.internal.SingletonNodeStream;
import net.sourceforge.pmd.lang.ast.internal.TraversalUtils;
import net.sourceforge.pmd.lang.ast.internal.TreeWalker;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StreamImpl {
    private static final NodeStream.DescendantNodeStream EMPTY = new EmptyNodeStream();

    private StreamImpl() {
    }

    public static <T extends Node> NodeStream.DescendantNodeStream<T> singleton(@NonNull T node) {
        return new SingletonNodeStream<T>(node);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <T extends Node> NodeStream<T> fromIterable(Iterable<? extends @Nullable T> iterable) {
        if (iterable instanceof Collection) {
            @Nullable Collection coll = (Collection)iterable;
            if (coll.isEmpty()) {
                return StreamImpl.empty();
            }
            if (coll.size() == 1) {
                return NodeStream.of((Node)coll.iterator().next());
            }
        }
        return StreamImpl.fromNonNullList(IteratorUtil.toNonNullList(iterable.iterator()));
    }

    public static <T extends Node> NodeStream<T> union(final Iterable<? extends @Nullable NodeStream<? extends T>> streams) {
        return new IteratorBasedNStream<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtil.flatMap(streams.iterator(), Iterable::iterator);
            }
        };
    }

    public static <T extends Node> NodeStream.DescendantNodeStream<T> empty() {
        return EMPTY;
    }

    public static <R extends Node> NodeStream<R> children(@NonNull Node node, Class<? extends R> target) {
        return StreamImpl.sliceChildren(node, Filtermap.isInstance(target), 0, node.getNumChildren());
    }

    public static NodeStream<Node> children(@NonNull Node node) {
        return StreamImpl.sliceChildren(node, Filtermap.NODE_IDENTITY, 0, node.getNumChildren());
    }

    public static <N extends GenericNode<N>> NodeStream<N> childrenArray(GenericNode<N> parent, final Node @NonNull [] array) {
        return new AxisStream.ChildrenStream(parent, 0, parent.getNumChildren()){

            @Override
            public void forEach(Consumer<? super @NonNull Node> action) {
                for (Node child : array) {
                    action.accept(child);
                }
            }

            @Override
            public List<Node> toList() {
                return Collections.unmodifiableList(Arrays.asList(array));
            }

            @Override
            protected Iterator<Node> baseIterator() {
                return Arrays.asList(array).iterator();
            }
        };
    }

    public static NodeStream.DescendantNodeStream<Node> descendants(@NonNull Node node) {
        return node.getNumChildren() == 0 ? StreamImpl.empty() : new AxisStream.DescendantStream(node, TreeWalker.DEFAULT);
    }

    public static <R extends Node> NodeStream.DescendantNodeStream<R> descendants(@NonNull Node node, Class<? extends R> rClass) {
        return node.getNumChildren() == 0 ? StreamImpl.empty() : new AxisStream.FilteredDescendantStream<R>(node, TreeWalker.DEFAULT, Filtermap.isInstance(rClass));
    }

    public static NodeStream.DescendantNodeStream<Node> descendantsOrSelf(@NonNull Node node) {
        return node.getNumChildren() == 0 ? StreamImpl.singleton(node) : new AxisStream.DescendantOrSelfStream(node, TreeWalker.DEFAULT);
    }

    public static NodeStream<Node> followingSiblings(@NonNull Node node) {
        Node parent = node.getParent();
        if (parent == null || parent.getNumChildren() == 1) {
            return NodeStream.empty();
        }
        return StreamImpl.sliceChildren(parent, Filtermap.NODE_IDENTITY, node.getIndexInParent() + 1, parent.getNumChildren() - node.getIndexInParent() - 1);
    }

    public static NodeStream<Node> precedingSiblings(@NonNull Node node) {
        Node parent = node.getParent();
        if (parent == null || parent.getNumChildren() == 1) {
            return NodeStream.empty();
        }
        return StreamImpl.sliceChildren(parent, Filtermap.NODE_IDENTITY, 0, node.getIndexInParent());
    }

    static <T extends Node> NodeStream<T> sliceChildren(Node parent, Filtermap<Node, ? extends T> filtermap, int from, int length) {
        assert (parent != null);
        assert (from >= 0 && from <= parent.getNumChildren()) : "from should be a valid index";
        assert (length >= 0) : "length should not be negative";
        assert (from + length >= 0 && from + length <= parent.getNumChildren()) : "from+length should be a valid index";
        if (length == 0) {
            return StreamImpl.empty();
        }
        if (filtermap == Filtermap.NODE_IDENTITY) {
            NodeStream<Node> res = length == 1 ? StreamImpl.singleton(parent.getChild(from)) : new AxisStream.ChildrenStream(parent, from, length);
            return res;
        }
        if (length == 1) {
            return NodeStream.of((Node)filtermap.apply(parent.getChild(from)));
        }
        return new AxisStream.FilteredChildrenStream<T>(parent, filtermap, from, length);
    }

    public static NodeStream<Node> ancestorsOrSelf(@Nullable Node node) {
        return StreamImpl.ancestorsOrSelf(node, Filtermap.NODE_IDENTITY);
    }

    static <T extends Node> NodeStream<T> ancestorsOrSelf(@Nullable Node node, Filtermap<Node, ? extends T> target) {
        if (node == null) {
            return StreamImpl.empty();
        }
        if (target == Filtermap.NODE_IDENTITY) {
            return new AxisStream.AncestorOrSelfStream(node);
        }
        T first = TraversalUtils.getFirstParentOrSelfMatching(node, target);
        if (first == null) {
            return StreamImpl.empty();
        }
        return new AxisStream.FilteredAncestorOrSelfStream<T>(first, target);
    }

    public static NodeStream<Node> ancestors(@NonNull Node node) {
        return StreamImpl.ancestorsOrSelf(node.getParent());
    }

    static <R extends Node> NodeStream<R> ancestors(@NonNull Node node, Filtermap<Node, ? extends R> target) {
        return StreamImpl.ancestorsOrSelf(node.getParent(), target);
    }

    public static <R extends Node> NodeStream<R> ancestors(@NonNull Node node, Class<? extends R> target) {
        return StreamImpl.ancestorsOrSelf(node.getParent(), Filtermap.isInstance(target));
    }

    static <T extends Node> NodeStream<T> fromNonNullList(List<@NonNull T> coll) {
        if (coll.isEmpty()) {
            return StreamImpl.empty();
        }
        if (coll.size() == 1) {
            return StreamImpl.singleton((Node)coll.get(0));
        }
        return new GreedyNStream.GreedyKnownNStream<T>(coll);
    }

    private static final class EmptyNodeStream<N extends Node>
    extends IteratorBasedNStream<N>
    implements NodeStream.DescendantNodeStream<N> {
        private EmptyNodeStream() {
        }

        @Override
        protected <R extends Node> NodeStream<R> mapIter(Function<Iterator<N>, Iterator<R>> fun) {
            return StreamImpl.empty();
        }

        @Override
        protected <R extends Node> @NonNull NodeStream.DescendantNodeStream<R> flatMapDescendants(Function<N, NodeStream.DescendantNodeStream<? extends R>> mapper) {
            return StreamImpl.empty();
        }

        @Override
        public NodeStream.DescendantNodeStream<N> crossFindBoundaries(boolean cross) {
            return this;
        }

        @Override
        public Iterator<N> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public List<N> toList() {
            return Collections.emptyList();
        }

        @Override
        public <R> List<R> toList(Function<? super N, ? extends R> mapper) {
            return Collections.emptyList();
        }

        @Override
        public Spliterator<N> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public NodeStream<N> cached() {
            return this;
        }

        @Override
        public String toString() {
            return "EmptyStream";
        }
    }
}

