/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.antlr4;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AntlrNameDictionary {
    private final String[] terminalXPathNames;
    private final String[] terminalImages;
    private final String[] nonTermXpathNames;
    private final Vocabulary vocabulary;

    public AntlrNameDictionary(Vocabulary vocab, String[] ruleNames) {
        this.vocabulary = vocab;
        this.nonTermXpathNames = new String[ruleNames.length];
        for (int i = 0; i < this.nonTermXpathNames.length; ++i) {
            this.nonTermXpathNames[i] = StringUtils.capitalize((String)ruleNames[i]);
        }
        HashSet<String> seen = new HashSet<String>();
        Collections.addAll(seen, ruleNames);
        this.terminalXPathNames = new String[vocab.getMaxTokenType()];
        this.terminalXPathNames[0] = "Invalid";
        this.terminalImages = new String[vocab.getMaxTokenType()];
        this.terminalImages[0] = null;
        for (int i = 1; i < this.terminalXPathNames.length; ++i) {
            String name = vocab.getSymbolicName(i);
            String literalName = vocab.getLiteralName(i);
            if (literalName != null) {
                this.terminalImages[i] = literalName = literalName.substring(1, literalName.length() - 1);
            }
            if (name == null && literalName != null && !(name = literalName).matches("[a-zA-Z][\\w_-]+")) {
                name = this.nonAlphaNumName(name);
            }
            assert (name != null) : "Token of kind " + i + " has no XPath name (literal " + vocab.getLiteralName(i) + ")";
            String finalName = "T-" + name;
            assert (finalName.matches("[a-zA-Z][\\w_-]+")) : "Not a valid XPath name " + finalName;
            assert (seen.add(finalName)) : "Duplicate XPath name " + finalName;
            this.terminalXPathNames[i] = finalName;
        }
        assert (Stream.of(this.terminalXPathNames).distinct().count() == (long)this.terminalXPathNames.length) : "Duplicate names in " + Arrays.toString(this.terminalXPathNames);
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    protected @Nullable String nonAlphaNumName(String name) {
        switch (name) {
            case "!": {
                return "bang";
            }
            case "!!": {
                return "double-bang";
            }
            case "?": {
                return "question";
            }
            case "??": {
                return "double-question";
            }
            case "?:": {
                return "elvis";
            }
            case "?.": {
                return "question-dot";
            }
            case ":": {
                return "colon";
            }
            case ";": {
                return "semi";
            }
            case ",": {
                return "comma";
            }
            case "(": {
                return "lparen";
            }
            case ")": {
                return "rparen";
            }
            case "[": {
                return "lbracket";
            }
            case "]": {
                return "rbracket";
            }
            case "{": {
                return "lbrace";
            }
            case "}": {
                return "rbrace";
            }
            case "_": {
                return "underscore";
            }
            case ".": {
                return "dot";
            }
            case "..": {
                return "double-dot";
            }
            case "...": {
                return "ellipsis";
            }
            case "@": {
                return "at-symbol";
            }
            case "$": {
                return "dollar";
            }
            case "#": {
                return "hash";
            }
            case "\\": {
                return "backslash";
            }
            case "/": {
                return "slash";
            }
            case "//": {
                return "double-slash";
            }
            case "`": {
                return "backtick";
            }
            case "'": {
                return "squote";
            }
            case "\"": {
                return "dquote";
            }
            case "\"\"\"": {
                return "triple-quote";
            }
            case ">": {
                return "gt";
            }
            case ">=": {
                return "ge";
            }
            case "<": {
                return "lt";
            }
            case "<=": {
                return "le";
            }
            case ">>": {
                return "double-gt";
            }
            case "<<": {
                return "double-lt";
            }
            case ">>>": {
                return "triple-gt";
            }
            case "<<<": {
                return "triple-lt";
            }
            case "=": {
                return "eq";
            }
            case "==": {
                return "double-eq";
            }
            case "===": {
                return "triple-eq";
            }
            case "!=": {
                return "not-eq";
            }
            case "&": {
                return "amp";
            }
            case "&&": {
                return "double-amp";
            }
            case "|": {
                return "pipe";
            }
            case "||": {
                return "double-pipe";
            }
            case "*": {
                return "star";
            }
            case "**": {
                return "double-star";
            }
            case "+": {
                return "plus";
            }
            case "++": {
                return "double-plus";
            }
            case "-": {
                return "minus";
            }
            case "--": {
                return "double-minus";
            }
            case "->": {
                return "rarrow";
            }
            case "<-": {
                return "larrow";
            }
        }
        return null;
    }

    public @NonNull String getXPathNameOfToken(int tokenType) {
        if (tokenType >= 0 && tokenType < this.terminalXPathNames.length) {
            return this.terminalXPathNames[tokenType];
        }
        if (tokenType == -1) {
            return "EOF";
        }
        throw new IllegalArgumentException("I don't know token type " + tokenType);
    }

    public @Nullable String getConstantImageOfToken(Token token) {
        int tokenType = token.getType();
        if (tokenType >= 0 && tokenType < this.terminalXPathNames.length) {
            return this.terminalImages[tokenType];
        }
        if (token.getStartIndex() == token.getStopIndex()) {
            return "";
        }
        return null;
    }

    public @NonNull String getXPathNameOfRule(int idx) {
        return this.nonTermXpathNames[idx];
    }

    public int getMaxRuleIndex() {
        return this.nonTermXpathNames.length;
    }

    public int getMaxTokenType() {
        return this.vocabulary.getMaxTokenType();
    }
}

