/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.text.MessageFormat;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.SemanticException;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.event.Level;

public interface SemanticErrorReporter {
    public void warning(Node var1, String var2, Object ... var3);

    public SemanticException error(Node var1, String var2, Object ... var3);

    default public void acceptError(SemanticException e) {
        e.setReported();
    }

    public @Nullable SemanticException getFirstError();

    public static SemanticErrorReporter noop() {
        return new SemanticErrorReporter(){
            private SemanticException exception;

            @Override
            public void warning(Node location, String message, Object ... formatArgs) {
            }

            @Override
            public SemanticException error(Node location, String message, Object ... formatArgs) {
                SemanticException ex = new SemanticException(MessageFormat.format(message, formatArgs));
                ex.setReported();
                if (this.exception == null) {
                    this.exception = ex;
                } else {
                    this.exception.addSuppressed((Throwable)((Object)ex));
                }
                return ex;
            }

            @Override
            public @Nullable SemanticException getFirstError() {
                return this.exception;
            }
        };
    }

    public static SemanticErrorReporter reportToLogger(final PmdReporter reporter) {
        return new SemanticErrorReporter(){
            private SemanticException exception = null;

            private String locPrefix(Node loc) {
                return "at " + loc.getReportLocation().startPosToStringWithFile() + ": ";
            }

            private String makeMessage(Node location, String message, Object[] args) {
                return this.locPrefix(location) + MessageFormat.format(message, args);
            }

            private String logMessage(Level level, Node location, String message, Object[] args) {
                String fullMessage = this.makeMessage(location, message, args);
                reporter.log(level, StringUtil.quoteMessageFormat(fullMessage), new Object[0]);
                return fullMessage;
            }

            @Override
            public void warning(Node location, String message, Object ... args) {
                this.logMessage(Level.DEBUG, location, message, args);
            }

            @Override
            public SemanticException error(Node location, String message, Object ... args) {
                String fullMessage = this.logMessage(Level.ERROR, location, message, args);
                SemanticException ex = new SemanticException(fullMessage);
                ex.setReported();
                this.updateException(ex);
                return ex;
            }

            private void updateException(SemanticException ex) {
                if (this.exception == null) {
                    this.exception = ex;
                } else {
                    this.exception.addSuppressed((Throwable)((Object)ex));
                }
            }

            @Override
            public void acceptError(SemanticException e) {
                if (!e.wasReported()) {
                    e.setReported();
                    reporter.log(Level.ERROR, StringUtil.quoteMessageFormat(e.getMessage()), new Object[0]);
                    this.updateException(e);
                }
            }

            @Override
            public @Nullable SemanticException getFirstError() {
                return this.exception;
            }
        };
    }
}

