/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.stream.Stream;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.StringUtils;

public interface GenericToken<T extends GenericToken<T>>
extends Comparable<T>,
Reportable {
    public T getNext();

    public T getPreviousComment();

    default public String getImage() {
        return this.getImageCs().toString();
    }

    public CharSequence getImageCs();

    default public boolean imageEquals(CharSequence charSeq) {
        CharSequence imageCs = this.getImageCs();
        if (imageCs instanceof Chars) {
            return ((Chars)imageCs).contentEquals(charSeq);
        }
        return StringUtils.equals((CharSequence)imageCs, (CharSequence)charSeq);
    }

    public TextRegion getRegion();

    public boolean isEof();

    default public boolean isImplicit() {
        return false;
    }

    @Override
    default public int compareTo(T o) {
        return this.getRegion().compareTo(o.getRegion());
    }

    public static <T extends GenericToken<T>> Iterable<T> range(T from, T to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException(from + " must come before " + to);
        }
        return () -> IteratorUtil.generate(from, t -> t == to ? null : (GenericToken)t.getNext());
    }

    public static <T extends GenericToken<T>> Stream<T> streamRange(T from, T to) {
        return IteratorUtil.toStream(GenericToken.range(from, to).iterator());
    }

    public static <T extends GenericToken<T>> Iterable<T> previousSpecials(T from) {
        return () -> IteratorUtil.generate(from.getPreviousComment(), GenericToken::getPreviousComment);
    }

    public int getKind();
}

