/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.DataMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AstInfo<T extends RootNode> {
    private final TextDocument textDocument;
    private final T rootNode;
    private final LanguageProcessorRegistry lpReg;
    private final Map<Integer, ViolationSuppressor.SuppressionCommentWrapper> suppressionComments;
    private final DataMap<DataMap.DataKey<?, ?>> userMap = DataMap.newDataMap();

    public AstInfo(Parser.ParserTask task, T rootNode) {
        this(task.getTextDocument(), rootNode, task.getLpRegistry(), Collections.emptyMap());
    }

    private AstInfo(TextDocument textDocument, T rootNode, LanguageProcessorRegistry lpReg, Map<Integer, ViolationSuppressor.SuppressionCommentWrapper> suppressionComments) {
        this.textDocument = AssertionUtil.requireParamNotNull("text document", textDocument);
        this.rootNode = (RootNode)AssertionUtil.requireParamNotNull("root node", rootNode);
        this.lpReg = lpReg;
        this.suppressionComments = AssertionUtil.requireParamNotNull("suppress map", suppressionComments);
    }

    public T getRootNode() {
        return this.rootNode;
    }

    public @NonNull TextDocument getTextDocument() {
        return this.textDocument;
    }

    public LanguageProcessor getLanguageProcessor() {
        return this.lpReg.getProcessor(this.textDocument.getLanguageVersion().getLanguage());
    }

    @Deprecated
    public Map<Integer, String> getSuppressionComments() {
        return CollectionUtil.mapView(this.suppressionComments, ViolationSuppressor.SuppressionCommentWrapper::getUserMessage);
    }

    public  @Nullable ViolationSuppressor.SuppressionCommentWrapper getSuppressionComment(int lineNumber) {
        return this.suppressionComments.get(lineNumber);
    }

    public Collection<ViolationSuppressor.SuppressionCommentWrapper> getAllSuppressionComments() {
        return Collections.unmodifiableCollection(this.suppressionComments.values());
    }

    public DataMap<DataMap.DataKey<?, ?>> getUserMap() {
        return this.userMap;
    }

    @Deprecated
    public AstInfo<T> withSuppressMap(Map<Integer, String> map) {
        HashSet<1> comments = new HashSet<1>();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            final String comment = entry.getValue();
            final int line = entry.getKey();
            comments.add(new ViolationSuppressor.SuppressionCommentWrapper(){

                @Override
                public String getUserMessage() {
                    return comment;
                }

                @Override
                public Reportable getLocation() {
                    return () -> FileLocation.caret(AstInfo.this.textDocument.getFileId(), line, 1);
                }
            });
        }
        return this.withSuppressionComments(comments);
    }

    public AstInfo<T> withSuppressionComments(Collection<? extends ViolationSuppressor.SuppressionCommentWrapper> suppressionComments) {
        HashMap<Integer, ViolationSuppressor.SuppressionCommentWrapper> suppressMap = new HashMap<Integer, ViolationSuppressor.SuppressionCommentWrapper>(suppressionComments.size());
        for (ViolationSuppressor.SuppressionCommentWrapper suppressionCommentWrapper : suppressionComments) {
            suppressMap.put(suppressionCommentWrapper.getLocation().getReportLocation().getStartLine(), suppressionCommentWrapper);
        }
        return new AstInfo<T>(this.textDocument, this.rootNode, this.lpReg, Collections.unmodifiableMap(suppressMap));
    }
}

