/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.util.Locale;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

final class FileExtensionFilter
implements Predicate<String> {
    private final String[] extensions;
    private final boolean ignoreCase;

    FileExtensionFilter(boolean ignoreCase, String ... extensions) {
        this.extensions = extensions;
        this.ignoreCase = ignoreCase;
        if (ignoreCase) {
            for (int i = 0; i < this.extensions.length; ++i) {
                this.extensions[i] = this.extensions[i].toUpperCase(Locale.ROOT);
            }
        }
    }

    @Override
    public boolean test(String path) {
        boolean accept;
        boolean bl = accept = this.extensions == null;
        if (!accept) {
            for (String extension : this.extensions) {
                boolean matches;
                boolean bl2 = matches = this.ignoreCase ? StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)extension) : path.endsWith(extension);
                if (!matches) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }
}

