/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.event.Level;

public final class Slf4jSimpleConfiguration {
    private static final String SIMPLE_LOGGER_FACTORY_CLASS = "org.slf4j.impl.SimpleLoggerFactory";
    private static final String SIMPLE_LOGGER_CLASS = "org.slf4j.impl.SimpleLogger";
    private static final String SIMPLE_LOGGER_CONFIGURATION = "org.slf4j.impl.SimpleLoggerConfiguration";
    private static final String PMD_ROOT_LOGGER = "net.sourceforge.pmd";

    private Slf4jSimpleConfiguration() {
    }

    public static void reconfigureDefaultLogLevel(Level level) {
        if (!Slf4jSimpleConfiguration.isSimpleLogger()) {
            return;
        }
        if (level != null) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", level.toString());
        }
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        ClassLoader classLoader = loggerFactory.getClass().getClassLoader();
        try {
            Class<?> simpleLoggerClass = classLoader.loadClass(SIMPLE_LOGGER_CLASS);
            Method initMethod = simpleLoggerClass.getDeclaredMethod("init", new Class[0]);
            initMethod.setAccessible(true);
            initMethod.invoke(null, new Object[0]);
            int newDefaultLogLevel = Slf4jSimpleConfiguration.getDefaultLogLevelInt(simpleLoggerClass);
            Field currentLogLevelField = simpleLoggerClass.getDeclaredField("currentLogLevel");
            currentLogLevelField.setAccessible(true);
            Method levelStringMethod = simpleLoggerClass.getDeclaredMethod("recursivelyComputeLevelString", new Class[0]);
            levelStringMethod.setAccessible(true);
            Method stringToLevelMethod = classLoader.loadClass(SIMPLE_LOGGER_CONFIGURATION).getDeclaredMethod("stringToLevel", String.class);
            stringToLevelMethod.setAccessible(true);
            Class<?> loggerFactoryClass = classLoader.loadClass(SIMPLE_LOGGER_FACTORY_CLASS);
            Field loggerMapField = loggerFactoryClass.getDeclaredField("loggerMap");
            loggerMapField.setAccessible(true);
            Map loggerMap = (Map)loggerMapField.get(loggerFactory);
            for (Logger logger : loggerMap.values()) {
                if (!logger.getName().startsWith(PMD_ROOT_LOGGER) || !simpleLoggerClass.isAssignableFrom(logger.getClass())) continue;
                String newConfiguredLevel = (String)levelStringMethod.invoke((Object)logger, new Object[0]);
                int newLogLevel = newDefaultLogLevel;
                if (newConfiguredLevel != null) {
                    newLogLevel = (Integer)stringToLevelMethod.invoke(null, newConfiguredLevel);
                }
                currentLogLevelField.set(logger, newLogLevel);
            }
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            System.err.println("Error while initializing logging: " + ex);
        }
    }

    private static int getDefaultLogLevelInt(Class<?> simpleLoggerClass) throws ReflectiveOperationException {
        Field configParamsField = simpleLoggerClass.getDeclaredField("CONFIG_PARAMS");
        configParamsField.setAccessible(true);
        Object configParams = configParamsField.get(null);
        Field defaultLogLevelField = configParams.getClass().getDeclaredField("defaultLogLevel");
        defaultLogLevelField.setAccessible(true);
        return (Integer)defaultLogLevelField.get(configParams);
    }

    public static Level getDefaultLogLevel() {
        Logger rootLogger = LoggerFactory.getLogger((String)PMD_ROOT_LOGGER);
        if (rootLogger.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (rootLogger.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (rootLogger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (rootLogger.isWarnEnabled()) {
            return Level.WARN;
        }
        if (rootLogger.isErrorEnabled()) {
            return Level.ERROR;
        }
        return Level.INFO;
    }

    public static void disableLogging(Class<?> clazz) {
        if (!Slf4jSimpleConfiguration.isSimpleLogger()) {
            return;
        }
        System.setProperty("org.slf4j.simpleLogger.log." + clazz.getName(), "off");
    }

    public static boolean isSimpleLogger() {
        try {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            Class<?> loggerFactoryClass = loggerFactory.getClass().getClassLoader().loadClass(SIMPLE_LOGGER_FACTORY_CLASS);
            return loggerFactoryClass.isAssignableFrom(loggerFactory.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void installJulBridge() {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

