/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.cpd.AnyCpdLexer;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.GridBagHelper;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.document.FileCollector;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.InternalApiBridge;
import net.sourceforge.pmd.lang.impl.CpdOnlyLanguageModuleBase;
import net.sourceforge.pmd.util.CollectionUtil;

public class GUI
implements CPDListener {
    private static final Object[][] RENDERER_SETS = new Object[][]{{"Text", new SimpleRenderer()}, {"XML", new XMLRenderer()}, {"CSV (comma)", new CSVRenderer(',')}, {"CSV (tab)", new CSVRenderer('\t')}};
    private static final List<LanguageConfig> LANGUAGE_SETS;
    private static final LanguageConfig CUSTOM_EXTENSION_LANG;
    private static final int DEFAULT_CPD_MINIMUM_LENGTH = 75;
    private static final Map<String, LanguageConfig> LANGUAGE_CONFIGS_BY_LABEL;
    private static final KeyStroke COPY_KEY_STROKE;
    private static final KeyStroke DELETE_KEY_STROKE;
    public static final Comparator<Match> LABEL_COMPARATOR;
    private final ColumnSpec[] matchColumns = new ColumnSpec[]{new ColumnSpec("Source", 2, -1, LABEL_COMPARATOR), new ColumnSpec("Matches", 4, 60, Match.MATCHES_COMPARATOR), new ColumnSpec("Lines", 4, 45, Match.LINES_COMPARATOR)};
    private final JTextField rootDirectoryField = new JTextField(System.getProperty("user.home"));
    private final JTextField minimumLengthField = new JTextField(Integer.toString(75));
    private final JTextField encodingField = new JTextField(System.getProperty("file.encoding"));
    private final JTextField timeField = new JTextField(6);
    private final JLabel phaseLabel = new JLabel();
    private final JProgressBar tokenizingFilesBar = new JProgressBar();
    private final JTextArea resultsTextArea = new JTextArea();
    private final JCheckBox recurseCheckbox = new JCheckBox("", true);
    private final JCheckBox ignoreIdentifiersCheckbox = new JCheckBox("", false);
    private final JCheckBox ignoreLiteralsCheckbox = new JCheckBox("", false);
    private final JCheckBox ignoreAnnotationsCheckbox = new JCheckBox("", false);
    private final JCheckBox ignoreUsingsCheckbox = new JCheckBox("", false);
    private final JCheckBox ignoreLiteralSequencesCheckbox = new JCheckBox("", false);
    private final JCheckBox ignoreIdentifierAndLiteralSequencesCheckbox = new JCheckBox("", false);
    private final JComboBox<String> languageBox = new JComboBox();
    private final JTextField extensionField = new JTextField();
    private final JLabel extensionLabel = new JLabel("Extension:", 4);
    private final JTable resultsTable = new JTable();
    private final JButton goButton;
    private final JButton cancelButton;
    private final JPanel progressPanel;
    private final JFrame frame;
    private boolean trimLeadingWhitespace;
    private List<Match> matches = new ArrayList<Match>();
    private SourceManager sourceManager;
    private Map<FileId, Integer> numberOfTokensPerFile;

    private static LanguageConfig languageConfigFor(String label) {
        return LANGUAGE_CONFIGS_BY_LABEL.get(label);
    }

    private void addSaveOptionsTo(JMenu menu) {
        for (Object[] rendererSet : RENDERER_SETS) {
            JMenuItem saveItem = new JMenuItem("Save as " + rendererSet[0]);
            saveItem.addActionListener(new SaveListener((CPDReportRenderer)rendererSet[1]));
            menu.add(saveItem);
        }
    }

    public GUI() {
        this.frame = new JFrame("PMD Duplicate Code Detector (v " + PMDVersion.VERSION + ')');
        this.timeField.setEditable(false);
        ExitAction exitAction = new ExitAction(this::closeSourceManager);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        this.addSaveOptionsTo(fileMenu);
        fileMenu.add(new JMenuItem(exitAction));
        JMenu viewMenu = new JMenu("View");
        fileMenu.setMnemonic('v');
        JCheckBoxMenuItem trimItem = new JCheckBoxMenuItem("Trim leading whitespace");
        trimItem.addItemListener(e -> {
            AbstractButton button = (AbstractButton)e.getItem();
            this.trimLeadingWhitespace = button.isSelected();
        });
        viewMenu.add(trimItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        this.frame.setJMenuBar(menuBar);
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        browseButton.addActionListener(new BrowseListener());
        this.goButton = new JButton("Go");
        this.goButton.setMnemonic('g');
        this.goButton.addActionListener(new GoListener());
        this.cancelButton = new JButton(exitAction);
        this.cancelButton.setText("Cancel");
        JPanel settingsPanel = this.makeSettingsPanel(browseButton, this.goButton, this.cancelButton);
        this.progressPanel = this.makeProgressPanel();
        JPanel resultsPanel = this.makeResultsPanel();
        this.adjustLanguageControlsFor(LANGUAGE_SETS.get(0));
        this.frame.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)settingsPanel, "North");
        topPanel.add((Component)this.progressPanel, "Center");
        this.setProgressControls(false);
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)resultsPanel, "Center");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GUI.this.closeSourceManager();
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void adjustLanguageControlsFor(LanguageConfig current) {
        this.ignoreIdentifiersCheckbox.setEnabled(current.canIgnoreIdentifiers());
        this.ignoreLiteralsCheckbox.setEnabled(current.canIgnoreLiterals());
        this.ignoreAnnotationsCheckbox.setEnabled(current.canIgnoreAnnotations());
        this.ignoreUsingsCheckbox.setEnabled(current.canIgnoreUsings());
        this.ignoreLiteralSequencesCheckbox.setEnabled(current.canIgnoreLiteralSequences());
        this.ignoreIdentifierAndLiteralSequencesCheckbox.setEnabled(current.canIgnoreIdentifierAndLiteralSequences());
        boolean enableExtension = current.canUseCustomExtension();
        if (enableExtension) {
            this.extensionField.setText("");
        } else {
            String firstExt = current.getLanguage().getExtensions().get(0);
            this.extensionField.setText(firstExt);
        }
        this.extensionField.setEnabled(enableExtension);
        this.extensionLabel.setEnabled(enableExtension);
    }

    private JPanel makeSettingsPanel(JButton browseButton, JButton goButton, JButton cxButton) {
        JPanel settingsPanel = new JPanel();
        GridBagHelper helper = new GridBagHelper(settingsPanel, new double[]{0.2, 0.7, 0.1, 0.1});
        helper.addLabel("Root source directory:");
        helper.add(this.rootDirectoryField);
        helper.add(browseButton, 2);
        helper.nextRow();
        helper.addLabel("Report duplicate chunks larger than:");
        this.minimumLengthField.setColumns(4);
        helper.add(this.minimumLengthField);
        helper.addLabel("Language:");
        for (LanguageConfig lconf : LANGUAGE_SETS) {
            this.languageBox.addItem(lconf.getLanguage().getName());
        }
        this.languageBox.addActionListener(e -> this.adjustLanguageControlsFor(GUI.languageConfigFor((String)this.languageBox.getSelectedItem())));
        helper.add(this.languageBox);
        helper.nextRow();
        helper.addLabel("Also scan subdirectories?");
        helper.add(this.recurseCheckbox);
        helper.add(this.extensionLabel);
        helper.add(this.extensionField);
        helper.nextRow();
        helper.addLabel("Ignore literals?");
        helper.add(this.ignoreLiteralsCheckbox);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore identifiers?");
        helper.add(this.ignoreIdentifiersCheckbox);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore annotations?");
        helper.add(this.ignoreAnnotationsCheckbox);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore usings?");
        helper.add(this.ignoreUsingsCheckbox);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore literal sequences?");
        helper.add(this.ignoreLiteralSequencesCheckbox);
        helper.add(goButton);
        helper.add(cxButton);
        helper.nextRow();
        helper.nextRow();
        helper.addLabel("Ignore identifier and literal sequences?");
        helper.add(this.ignoreIdentifierAndLiteralSequencesCheckbox);
        helper.add(goButton);
        helper.add(cxButton);
        helper.nextRow();
        helper.addLabel("File encoding (defaults based upon locale):");
        this.encodingField.setColumns(1);
        helper.add(this.encodingField);
        helper.addLabel("");
        helper.addLabel("");
        helper.nextRow();
        return settingsPanel;
    }

    private JPanel makeProgressPanel() {
        JPanel progressPanel = new JPanel();
        double[] weights = new double[]{0.0, 0.8, 0.4, 0.2};
        GridBagHelper helper = new GridBagHelper(progressPanel, weights);
        helper.addLabel("Tokenizing files:");
        helper.add(this.tokenizingFilesBar, 3);
        helper.nextRow();
        helper.addLabel("Phase:");
        helper.add(this.phaseLabel);
        helper.addLabel("Time elapsed:");
        helper.add(this.timeField);
        helper.nextRow();
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        return progressPanel;
    }

    private JPanel makeResultsPanel() {
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BorderLayout());
        JScrollPane areaScrollPane = new JScrollPane(this.resultsTextArea);
        this.resultsTextArea.setEditable(false);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(600, 300));
        resultsPanel.add((Component)this.makeMatchList(), "West");
        resultsPanel.add((Component)areaScrollPane, "Center");
        return resultsPanel;
    }

    private void populateResultArea() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        TableModel model = this.resultsTable.getModel();
        ArrayList<Match> selections = new ArrayList<Match>(selectionIndices.length);
        for (int selectionIndex : selectionIndices) {
            selections.add((Match)model.getValueAt(selectionIndex, 99));
        }
        CPDReport toRender = new CPDReport(this.sourceManager, selections, Collections.emptyMap(), Collections.emptyList());
        String report = new SimpleRenderer(this.trimLeadingWhitespace).renderToString(toRender);
        this.resultsTextArea.setText(report);
        this.resultsTextArea.setCaretPosition(0);
    }

    private void copyMatchListSelectionsToClipboard() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        int colCount = this.resultsTable.getColumnCount();
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < selectionIndices.length; ++r) {
            if (r > 0) {
                sb.append('\n');
            }
            sb.append(this.resultsTable.getValueAt(selectionIndices[r], 0));
            for (int c = 1; c < colCount; ++c) {
                sb.append('\t');
                sb.append(this.resultsTable.getValueAt(selectionIndices[r], c));
            }
        }
        StringSelection ss = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    private void deleteMatchlistSelections() {
        int[] selectionIndices = this.resultsTable.getSelectedRows();
        for (int i = selectionIndices.length - 1; i >= 0; --i) {
            this.matches.remove(selectionIndices[i]);
        }
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.addNotify();
    }

    private JComponent makeMatchList() {
        this.resultsTable.getSelectionModel().addListSelectionListener(e -> this.populateResultArea());
        this.resultsTable.registerKeyboardAction(e -> this.copyMatchListSelectionsToClipboard(), "Copy", COPY_KEY_STROKE, 0);
        this.resultsTable.registerKeyboardAction(e -> this.deleteMatchlistSelections(), "Del", DELETE_KEY_STROKE, 0);
        int[] alignments = new int[this.matchColumns.length];
        for (int i = 0; i < alignments.length; ++i) {
            alignments[i] = this.matchColumns[i].alignment();
        }
        this.resultsTable.setDefaultRenderer(Object.class, new AlignmentRenderer(alignments));
        final JTableHeader header = this.resultsTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GUI.this.sortOnColumn(header.columnAtPoint(new Point(e.getX(), e.getY())));
            }
        });
        return new JScrollPane(this.resultsTable);
    }

    private static String getLabel(Match match) {
        HashSet<FileId> sourceIDs = new HashSet<FileId>(match.getMarkCount());
        for (Mark mark : match) {
            sourceIDs.add(mark.getLocation().getFileId());
        }
        if (sourceIDs.size() == 1) {
            FileId sourceId = (FileId)sourceIDs.iterator().next();
            return "..." + sourceId.getFileName();
        }
        return String.format("(%d separate files)", sourceIDs.size());
    }

    private void setProgressControls(boolean isRunning) {
        this.progressPanel.setVisible(isRunning);
        this.goButton.setEnabled(!isRunning);
        this.cancelButton.setEnabled(isRunning);
    }

    private void go() {
        this.closeSourceManager();
        try {
            File dirPath = new File(this.rootDirectoryField.getText());
            if (!dirPath.exists()) {
                JOptionPane.showMessageDialog(this.frame, "Can't read from that root source directory", "Error", 0);
                return;
            }
            this.setProgressControls(true);
            CPDConfiguration config = new CPDConfiguration();
            config.setMinimumTileSize(Integer.parseInt(this.minimumLengthField.getText()));
            try {
                config.setSourceEncoding(Charset.forName(this.encodingField.getText()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            config.setIgnoreIdentifiers(this.ignoreIdentifiersCheckbox.isSelected());
            config.setIgnoreLiterals(this.ignoreLiteralsCheckbox.isSelected());
            config.setIgnoreAnnotations(this.ignoreAnnotationsCheckbox.isSelected());
            config.setIgnoreUsings(this.ignoreUsingsCheckbox.isSelected());
            config.setIgnoreLiteralSequences(this.ignoreLiteralSequencesCheckbox.isSelected());
            config.setIgnoreIdentifierAndLiteralSequences(this.ignoreIdentifierAndLiteralSequencesCheckbox.isSelected());
            if (this.extensionField.isEnabled()) {
                CUSTOM_EXTENSION_LANG.setExtension(this.extensionField.getText());
            }
            LanguageConfig conf = GUI.languageConfigFor((String)this.languageBox.getSelectedItem());
            Language language = conf.getLanguage();
            config.setOnlyRecognizeLanguage(language);
            try (CpdAnalysis cpd = CpdAnalysis.create(config);){
                cpd.setCpdListener(this);
                this.tokenizingFilesBar.setMinimum(0);
                this.phaseLabel.setText("");
                cpd.files().addFileOrDirectory(dirPath.toPath(), this.recurseCheckbox.isSelected());
                Timer t = this.createTimer();
                t.start();
                cpd.performAnalysis(report -> {
                    t.stop();
                    this.numberOfTokensPerFile = report.getNumberOfTokensPerFile();
                    this.matches = new ArrayList<Match>(report.getMatches());
                    this.setListDataFrom(this.matches);
                    this.prepareNewSourceManager(config, dirPath.toPath(), this.recurseCheckbox.isSelected());
                    String reportString = new SimpleRenderer().renderToString((CPDReport)report);
                    if (reportString.isEmpty()) {
                        JOptionPane.showMessageDialog(this.frame, "Done. Couldn't find any duplicates longer than " + this.minimumLengthField.getText() + " tokens");
                    } else {
                        this.resultsTextArea.setText(reportString);
                    }
                });
            }
        }
        catch (IOException | RuntimeException t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Halted due to " + t.getClass().getName() + "; " + t.getMessage());
        }
        this.setProgressControls(false);
    }

    private void closeSourceManager() {
        try {
            if (this.sourceManager != null) {
                this.sourceManager.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareNewSourceManager(CPDConfiguration config, Path dirPath, boolean recurse) {
        try {
            this.closeSourceManager();
            FileCollector fileCollector = InternalApiBridge.newCollector(config.getLanguageVersionDiscoverer(), config.getReporter());
            fileCollector.addFileOrDirectory(dirPath, recurse);
            this.sourceManager = new SourceManager(fileCollector.getCollectedFiles());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Timer createTimer() {
        long start = System.currentTimeMillis();
        return new Timer(1000, e -> {
            long now = System.currentTimeMillis();
            long elapsedMillis = now - start;
            long elapsedSeconds = elapsedMillis / 1000L;
            long minutes = elapsedSeconds / 60L;
            long seconds = elapsedSeconds - minutes * 60L;
            this.timeField.setText(GUI.formatTime(minutes, seconds));
        });
    }

    private static String formatTime(long minutes, long seconds) {
        StringBuilder sb = new StringBuilder(5);
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes).append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
        return sb.toString();
    }

    private TableModel tableModelFrom(final List<Match> items) {
        return new SortingTableModel<Match>(){
            private int sortColumn;
            private boolean sortDescending;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Match match = (Match)items.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return GUI.getLabel(match);
                    }
                    case 2: {
                        return Integer.toString(match.getLineCount());
                    }
                    case 1: {
                        return match.getMarkCount() > 2 ? Integer.toString(match.getMarkCount()) : "";
                    }
                    case 99: {
                        return match;
                    }
                }
                return "";
            }

            @Override
            public int getColumnCount() {
                return GUI.this.matchColumns.length;
            }

            @Override
            public int getRowCount() {
                return items.size();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Object.class;
            }

            @Override
            public String getColumnName(int i) {
                return GUI.this.matchColumns[i].label();
            }

            @Override
            public int sortColumn() {
                return this.sortColumn;
            }

            @Override
            public void sortColumn(int column) {
                this.sortColumn = column;
            }

            @Override
            public boolean sortDescending() {
                return this.sortDescending;
            }

            @Override
            public void sortDescending(boolean flag) {
                this.sortDescending = flag;
            }

            @Override
            public void sort(Comparator<Match> comparator) {
                if (this.sortDescending) {
                    comparator = comparator.reversed();
                }
                items.sort(comparator);
            }
        };
    }

    private void sortOnColumn(int columnIndex) {
        Comparator<Match> comparator = this.matchColumns[columnIndex].sorter();
        SortingTableModel model = (SortingTableModel)this.resultsTable.getModel();
        if (model.sortColumn() == columnIndex) {
            model.sortDescending(!model.sortDescending());
        }
        model.sortColumn(columnIndex);
        model.sort(comparator);
        this.resultsTable.getSelectionModel().clearSelection();
        this.resultsTable.repaint();
    }

    private void setListDataFrom(List<Match> matches) {
        this.resultsTable.setModel(this.tableModelFrom(matches));
        TableColumnModel colModel = this.resultsTable.getColumnModel();
        for (int i = 0; i < this.matchColumns.length; ++i) {
            if (this.matchColumns[i].width() <= 0) continue;
            TableColumn column = colModel.getColumn(i);
            int width = this.matchColumns[i].width();
            column.setPreferredWidth(width);
            column.setMinWidth(width);
            column.setMaxWidth(width);
        }
    }

    @Override
    public void phaseUpdate(int phase) {
        this.phaseLabel.setText(this.getPhaseText(phase));
    }

    public String getPhaseText(int phase) {
        switch (phase) {
            case 0: {
                return "Initializing";
            }
            case 1: {
                return "Hashing";
            }
            case 2: {
                return "Matching";
            }
            case 3: {
                return "Grouping";
            }
            case 4: {
                return "Done";
            }
        }
        return "Unknown";
    }

    @Override
    public void addedFile(int fileCount) {
        this.tokenizingFilesBar.setMaximum(fileCount);
        this.tokenizingFilesBar.setValue(this.tokenizingFilesBar.getValue() + 1);
    }

    public static void main(String[] args) {
        new GUI();
    }

    static {
        CUSTOM_EXTENSION_LANG = new LanguageConfig(){
            private String extension = "custom_ext";

            @Override
            void setExtension(String extension) {
                this.extension = extension;
            }

            @Override
            boolean canUseCustomExtension() {
                return true;
            }

            @Override
            public Language getLanguage() {
                return new CpdOnlyLanguageModuleBase(LanguageModuleBase.LanguageMetadata.withId("custom_extension").extensions(this.extension, new String[0]).name("By extension...")){

                    @Override
                    public CpdLexer createCpdLexer(LanguagePropertyBundle bundle) {
                        return new AnyCpdLexer();
                    }
                };
            }
        };
        ArrayList<LanguageConfig> languages = new ArrayList<LanguageConfig>();
        LanguageRegistry.CPD.getLanguages().stream().map(l -> new LanguageConfig((Language)l){
            final /* synthetic */ Language val$l;
            {
                this.val$l = language;
            }

            @Override
            public Language getLanguage() {
                return this.val$l;
            }
        }).forEach(languages::add);
        Collections.sort(languages, Comparator.comparing(LanguageConfig::getLanguage));
        languages.add(CUSTOM_EXTENSION_LANG);
        LANGUAGE_SETS = languages;
        LANGUAGE_CONFIGS_BY_LABEL = CollectionUtil.associateBy(LANGUAGE_SETS, l -> l.getLanguage().getName());
        COPY_KEY_STROKE = KeyStroke.getKeyStroke(67, 2, false);
        DELETE_KEY_STROKE = KeyStroke.getKeyStroke(127, 0);
        LABEL_COMPARATOR = Comparator.comparing(GUI::getLabel);
    }

    private static abstract class SortingTableModel<E>
    extends AbstractTableModel {
        private SortingTableModel() {
        }

        abstract int sortColumn();

        abstract void sortColumn(int var1);

        abstract boolean sortDescending();

        abstract void sortDescending(boolean var1);

        abstract void sort(Comparator<E> var1);
    }

    private static class AlignmentRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -2190382865483285032L;
        private final int[] alignments;

        AlignmentRenderer(int[] theAlignments) {
            this.alignments = theAlignments;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(this.alignments[column]);
            return this;
        }
    }

    private final class BrowseListener
    implements ActionListener {
        private BrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(GUI.this.rootDirectoryField.getText());
            fc.setFileSelectionMode(2);
            fc.showDialog(GUI.this.frame, "Select");
            if (fc.getSelectedFile() != null) {
                GUI.this.rootDirectoryField.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        final CPDReportRenderer renderer;

        SaveListener(CPDReportRenderer theRenderer) {
            this.renderer = theRenderer;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fcSave = new JFileChooser();
            int ret = fcSave.showSaveDialog(GUI.this.frame);
            File f = fcSave.getSelectedFile();
            if (f == null || ret != 0) {
                return;
            }
            if (!f.canWrite()) {
                CPDReport report = new CPDReport(GUI.this.sourceManager, GUI.this.matches, GUI.this.numberOfTokensPerFile, Collections.emptyList());
                try (PrintWriter pw = new PrintWriter(Files.newOutputStream(f.toPath(), new OpenOption[0]));){
                    this.renderer.render(report, pw);
                    pw.flush();
                    JOptionPane.showMessageDialog(GUI.this.frame, "Saved " + GUI.this.matches.size() + " matches");
                }
                catch (IOException e) {
                    this.error("Couldn't save file" + f.getAbsolutePath(), e);
                }
            } else {
                this.error("Could not write to file " + f.getAbsolutePath(), null);
            }
        }

        private void error(String message, Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(GUI.this.frame, message);
        }
    }

    private final class GoListener
    implements ActionListener {
        private GoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(() -> {
                GUI.this.tokenizingFilesBar.setValue(0);
                GUI.this.tokenizingFilesBar.setString("");
                GUI.this.resultsTextArea.setText("");
                GUI.this.phaseLabel.setText("");
                GUI.this.timeField.setText("");
                GUI.this.go();
            }).start();
        }
    }

    private static final class ExitAction
    extends AbstractAction {
        private final Runnable cleanupTask;

        private ExitAction(Runnable cleanupTask) {
            this.cleanupTask = cleanupTask;
            this.putValue("Name", "Exit");
            this.putValue("MnemonicKey", 88);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.cleanupTask != null) {
                try {
                    this.cleanupTask.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }
    }

    private static class ColumnSpec {
        private final String label;
        private final int alignment;
        private final int width;
        private final Comparator<Match> sorter;

        ColumnSpec(String aLabel, int anAlignment, int aWidth, Comparator<Match> aSorter) {
            this.label = aLabel;
            this.alignment = anAlignment;
            this.width = aWidth;
            this.sorter = aSorter;
        }

        public String label() {
            return this.label;
        }

        public int alignment() {
            return this.alignment;
        }

        public int width() {
            return this.width;
        }

        public Comparator<Match> sorter() {
            return this.sorter;
        }
    }

    private static abstract class LanguageConfig {
        private LanguageConfig() {
        }

        public abstract Language getLanguage();

        boolean canUseCustomExtension() {
            return false;
        }

        void setExtension(String extension) {
        }

        public boolean canIgnoreIdentifiers() {
            return this.getLanguage().newPropertyBundle().hasDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS);
        }

        public boolean canIgnoreLiterals() {
            return this.getLanguage().newPropertyBundle().hasDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS);
        }

        public boolean canIgnoreAnnotations() {
            return this.getLanguage().newPropertyBundle().hasDescriptor(CpdLanguageProperties.CPD_IGNORE_METADATA);
        }

        public boolean canIgnoreUsings() {
            return this.getLanguage().newPropertyBundle().hasDescriptor(CpdLanguageProperties.CPD_IGNORE_IMPORTS);
        }

        public boolean canIgnoreLiteralSequences() {
            return this.getLanguage().newPropertyBundle().hasDescriptor(CpdLanguageProperties.CPD_IGNORE_LITERAL_SEQUENCES);
        }

        public boolean canIgnoreIdentifierAndLiteralSequences() {
            return this.getLanguage().newPropertyBundle().hasDescriptor(CpdLanguageProperties.CPD_IGNORE_LITERAL_AND_IDENTIFIER_SEQUENCES);
        }
    }
}

