/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;

class CachedRuleMapper {
    private final Map<String, Rule> cachedRulesInstances = new HashMap<String, Rule>();

    CachedRuleMapper() {
    }

    public Rule getRuleForClass(String className, String ruleName, String languageName) {
        return this.cachedRulesInstances.get(this.getRuleKey(className, ruleName, languageName));
    }

    public void initialize(RuleSets rs) {
        for (Rule r : rs.getAllRules()) {
            this.cachedRulesInstances.put(this.getRuleKey(r.getRuleClass(), r.getName(), r.getLanguage().getId()), r);
        }
    }

    private String getRuleKey(String className, String ruleName, String languageName) {
        return className + "$$" + ruleName + "$$" + languageName;
    }
}

