/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.io.IOException;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.treeexport.TreeRenderer;
import net.sourceforge.pmd.util.treeexport.TreeRenderers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class TreeRenderersTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    TreeRenderersTest() {
    }

    @Test
    void testStandardRenderersAreRegistered() {
        Assertions.assertEquals((Object)TreeRenderers.XML, (Object)TreeRenderers.findById((String)TreeRenderers.XML.id()));
    }

    @Test
    void testXmlPropertiesAvailable() {
        PropertySource properties = TreeRenderers.XML.newPropertyBundle();
        MatcherAssert.assertThat((Object)properties.getPropertyDescriptors(), (Matcher)Matchers.containsInAnyOrder((Object[])new PropertyDescriptor[]{TreeRenderers.XML_LINE_SEPARATOR, TreeRenderers.XML_RENDER_COMMON_ATTRIBUTES, TreeRenderers.XML_RENDER_PROLOG, TreeRenderers.XML_USE_SINGLE_QUOTES}));
    }

    @Test
    void testXmlDescriptorDump() throws IOException {
        PropertySource bundle = TreeRenderers.XML.newPropertyBundle();
        bundle.setProperty(TreeRenderers.XML_RENDER_PROLOG, (Object)false);
        bundle.setProperty(TreeRenderers.XML_USE_SINGLE_QUOTES, (Object)false);
        bundle.setProperty(TreeRenderers.XML_LINE_SEPARATOR, (Object)"\n");
        TreeRenderer renderer = TreeRenderers.XML.produceRenderer(bundle);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)TreeRenderersTest.dummyTree1(this.helper), (Appendable)out);
        Assertions.assertEquals((Object)"<dummyNode foo=\"bar\" ohio=\"4\">\n    <dummyNode o=\"ha\" />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    static DummyNode dummyTree1(DummyParsingHelper helper) {
        DummyNode dummy = (DummyNode)helper.parse("(parent(child1)(child2))").getChild(0);
        dummy.clearXPathAttributes();
        dummy.setXPathAttribute("foo", "bar");
        dummy.setXPathAttribute("ohio", "4");
        DummyNode dummy1 = (DummyNode)dummy.getChild(0);
        dummy1.clearXPathAttributes();
        dummy1.setXPathAttribute("o", "ha");
        ((DummyNode)dummy.getChild(1)).clearXPathAttributes();
        return dummy;
    }
}

