/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.util.database.DBType;
import net.sourceforge.pmd.util.database.DBURI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DBURITest {
    static final String C_TEST_DEFAULTS = "jdbc:oracle:testdefault://192.168.100.21:1521/ORCL";
    static final String C_DEFAULT_USER = "scott";
    static final String C_DEFAULT_PASSWORD = "tiger";
    static final String C_DEFAULT_LANGUAGES = "java,plsql";
    static final String C_DEFAULT_SCHEMAS = "scott,system";
    static final String C_DEFAULT_SOURCE_CODE_TYPES = "table,view";
    static final String C_DEFAULT_SOURCE_CODE_NAMES = "emp,dept";
    static final String C_DEFAULT_CHARACTERSET = "utf8";
    static final String C_TEST_EXPLICIT = "jdbc:oracle:testdefault:system/oracle@//192.168.100.21:1521/ORCL?characterset=us7ascii&schemas=scott,hr,sh,system&sourcecodetypes=procedures,functions,triggers,package,types&languages=plsql,java&sourcecodenames=PKG_%25%25,PRC_%25%25";
    static final String C_EXPLICIT_USER = "system";
    static final String C_EXPLICIT_PASSWORD = "oracle";
    static final String C_EXPLICIT_LANGUAGES = "plsql,java";
    static final String C_EXPLICIT_SCHEMAS = "scott,hr,sh,system";
    static final String C_EXPLICIT_SOURCE_CODE_TYPES = "procedures,functions,triggers,package,types";
    static final String C_EXPLICIT_SOURCE_CODE_NAMES = "PKG_%%,PRC_%%";
    static final String C_EXPLICIT_CHARACTERSET = "us7ascii";
    static final String C_TEST_URI = "test?param1=x%261&param2=&param3=";
    static final String C_ORACLE_OCI_1 = "jdbc:oracle:oci:system/oracle@//192.168.100.21:1521/ORCL";
    static final String C_ORACLE_OCI_2 = "jdbc:oracle:oci:system/oracle@//192.168.100.21:1521/ORCL?characterset=utf8&schemas=scott,hr,sh,system&sourcecodetypes=procedures,functions,triggers,package,types&languages=plsql,java";
    static final String C_ORACLE_OCI_3 = "jdbc:oracle:oci:system/oracle@//myserver.com:1521/customer_db?characterset=utf8&schemas=scott,hr,sh,system&sourcecodetypes=procedures,functions,triggers,package,types&languages=plsql,java&sourcecodenames=PKG_%25%25,PRC_%25%25";
    static final String C_ORACLE_THIN_1 = "jdbc:oracle:thin:system/oracle@//192.168.100.21:1521/ORCL";
    static final String C_ORACLE_THIN_2 = "jdbc:oracle:thin:system/oracle@//192.168.100.21:1521/ORCL?characterset=utf8&schemas=scott,hr,sh,system&sourcecodetypes=procedures,functions,triggers,package,types&languages=plsql,java";
    static final String C_ORACLE_THIN_3 = "jdbc:oracle:thin:system/oracle@//myserver.com:1521/customer_db?characterset=utf8&schemas=scott,hr,sh,system&sourcecodetypes=procedures,functions,triggers,package,types&languages=plsql,java&sourcecodenames=PKG_%25%25,PRC_%25%25";
    static final String C_POSTGRES_1 = "jdbc:postgresql://host/database";
    static final String C_HTTP = "http://localhost:80?characterset=utf8&schemas=scott,hr,sh,system&sourcecodetypes=procedures,functions,triggers,package,types&languages=plsql,java";

    DBURITest() {
    }

    static void dump(String description, URI dburi) {
        System.err.printf("Test %s\n: isOpaque=%s, isAbsolute=%s Scheme=%s,\n SchemeSpecificPart=%s,\n Host=%s,\n Port=%s,\n Path=%s,\n Fragment=%s,\n Query=%s\n", description, dburi.isOpaque(), dburi.isAbsolute(), dburi.getScheme(), dburi.getSchemeSpecificPart(), dburi.getHost(), dburi.getPort(), dburi.getPath(), dburi.getFragment(), dburi.getQuery());
        String query = dburi.getQuery();
        if (null != query && !"".equals(query)) {
            String[] params = query.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : params) {
                String[] splits = param.split("=");
                String name = splits[0];
                String value = null;
                if (splits.length > 1) {
                    value = splits[1];
                }
                map.put(name, value);
                System.err.printf("name=%s,value=%s\n", name, value);
            }
        }
    }

    @Test
    void testDump() throws URISyntaxException, Exception {
        System.out.println("dump");
        String description = "";
        DBURI dburi = new DBURI(C_TEST_URI);
        DBURI.dump((String)description, (URI)dburi.getUri());
    }

    @Test
    void testGetUri() throws URISyntaxException, Exception {
        System.out.println("getUri");
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        URI expResult = new URI(C_ORACLE_OCI_1);
        URI result = instance.getUri();
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testSetUri() throws URISyntaxException, Exception {
        System.out.println("setUri");
        URI uri = new URI(C_ORACLE_OCI_1);
        DBURI instance = new DBURI(C_TEST_URI);
        instance.setUri(uri);
        Assertions.assertEquals((Object)uri, (Object)instance.getUri());
    }

    @Test
    void testGetDbType() throws URISyntaxException, Exception {
        System.out.println("getDbType");
        DBURI instance = new DBURI(C_POSTGRES_1);
        DBType expResult = new DBType("postgresql");
        DBType result = instance.getDbType();
    }

    @Test
    void testGetDbType2() throws URISyntaxException, Exception {
        System.out.println("getDbType");
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        DBType expResult = new DBType("oci");
        DBType result = instance.getDbType();
    }

    @Test
    void testSetDbType() throws URISyntaxException, Exception {
        System.out.println("setDbType");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        DBType dbType = new DBType("postgresql");
        instance.setDbType(dbType);
        Assertions.assertEquals((Object)dbType, (Object)instance.getDbType());
    }

    @Test
    void testGetSchemasList() throws URISyntaxException, Exception {
        System.out.println("getSchemasList");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        List<String> expResult = Arrays.asList(C_EXPLICIT_SCHEMAS.split(","));
        List result = instance.getSchemasList();
        Assertions.assertEquals(expResult, (Object)result);
    }

    @Test
    void testSetSchemasList() throws URISyntaxException, Exception {
        System.out.println("setSchemasList");
        List<String> schemasList = Arrays.asList(C_EXPLICIT_SCHEMAS.split(","));
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        instance.setSchemasList(schemasList);
    }

    @Test
    void testGetSourceCodeTypesList() throws URISyntaxException, Exception {
        System.out.println("getSourceCodeTypesList");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        List<String> expResult = Arrays.asList(C_EXPLICIT_SOURCE_CODE_TYPES.split(","));
        List result = instance.getSourceCodeTypesList();
        Assertions.assertEquals(expResult, (Object)result);
    }

    @Test
    void testSetSourceCodeTypesList() throws URISyntaxException, Exception {
        System.out.println("setSourceCodeTypesList");
        List<String> sourcecodetypesList = Arrays.asList(C_EXPLICIT_SOURCE_CODE_TYPES.split(","));
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        instance.setSourceCodeTypesList(sourcecodetypesList);
    }

    @Test
    void testGetSourceCodeNamesList() throws URISyntaxException, Exception {
        System.out.println("getSourceCodeNamesList");
        DBURI instance = new DBURI(C_ORACLE_OCI_3);
        List<String> expResult = Arrays.asList(C_EXPLICIT_SOURCE_CODE_NAMES.split(","));
        List result = instance.getSourceCodeNamesList();
        Assertions.assertEquals(expResult, (Object)result);
    }

    @Test
    void testSetSourceCodeNamesList() throws URISyntaxException, Exception {
        System.out.println("setSourceCodeNamesList");
        List<String> sourceCodeNamesList = Arrays.asList("PKG_%%,TRG_%%".split(","));
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        instance.setSourceCodeNamesList(sourceCodeNamesList);
    }

    @Test
    void testGetLanguagesList() throws URISyntaxException, Exception {
        System.out.println("getLanguagesList");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        List<String> expResult = Arrays.asList(C_EXPLICIT_LANGUAGES.split(","));
        List result = instance.getLanguagesList();
        Assertions.assertEquals(expResult, (Object)result);
    }

    @Test
    void testSetLanguagesList() throws URISyntaxException, Exception {
        System.out.println("setLanguagesList");
        List<String> languagesList = Arrays.asList(C_EXPLICIT_LANGUAGES.split(","));
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        instance.setLanguagesList(languagesList);
    }

    @Test
    void testGetDriverClass() throws URISyntaxException, Exception {
        System.out.println("getDriverClass");
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        String expResult = "oracle.jdbc.OracleDriver";
        String result = instance.getDriverClass();
        System.out.println("testGetDriverClass: driverClass=" + result);
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testGetThinDriverClass() throws URISyntaxException, Exception {
        System.out.println("getThinDriverClass");
        DBURI instance = new DBURI(C_ORACLE_THIN_1);
        String expResult = "oracle.jdbc.OracleDriver";
        String result = instance.getDriverClass();
        System.out.println("testGetThinDriverClass: driverClass=" + result);
        System.out.println("testGetThinDriverClass: getDbType().getProperties() follows");
        System.out.println("testGetThinDriverClass: getDbType().getProperties()=" + instance.getDbType().getProperties());
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testSetDriverClass() throws URISyntaxException, Exception {
        System.out.println("setDriverClass");
        String driverClass = "oracle.jdbc.driver.OracleDriver";
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        instance.setDriverClass(driverClass);
    }

    @Test
    void testGetCharacterSet() throws URISyntaxException, Exception {
        System.out.println("getCharacterSet");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        String expResult = C_DEFAULT_CHARACTERSET;
        String result = instance.getCharacterSet();
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testSetCharacterSet() throws URISyntaxException, Exception {
        System.out.println("setCharacterSet");
        String characterSet = C_DEFAULT_CHARACTERSET;
        DBURI instance = new DBURI(C_POSTGRES_1);
        instance.setCharacterSet(characterSet);
    }

    @Test
    void testGetSourceCodeType() throws URISyntaxException, Exception {
        System.out.println("getSourceCodeType");
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        int expResult = 2005;
        int result = instance.getSourceCodeType();
        Assertions.assertEquals((int)expResult, (int)result);
    }

    @Test
    void testSetSourceCodeType() throws URISyntaxException, Exception {
        System.out.println("setSourceCodeType");
        int sourceCodeType = 5;
        DBURI instance = new DBURI(C_ORACLE_OCI_1);
        instance.setSourceCodeType(sourceCodeType);
    }

    @Test
    void testGetSubprotocol() throws URISyntaxException, Exception {
        System.out.println("getSubprotocol");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        String expResult = C_EXPLICIT_PASSWORD;
        String result = instance.getSubprotocol();
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testSetSubprotocol() throws URISyntaxException, Exception {
        System.out.println("setSubprotocol");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        String subprotocol = C_EXPLICIT_PASSWORD;
        instance.setSubprotocol(subprotocol);
        String result = instance.getSubprotocol();
        Assertions.assertEquals((Object)subprotocol, (Object)result);
    }

    @Test
    void testGetSubnamePrefix() throws URISyntaxException, Exception {
        System.out.println("getSubnamePrefix");
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        String expResult = "oci";
        String result = instance.getSubnamePrefix();
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testSetSubnamePrefix() throws URISyntaxException, Exception {
        System.out.println("setSubnamePrefix");
        String subnamePrefix = "oci8";
        DBURI instance = new DBURI(C_ORACLE_OCI_2);
        instance.setSubnamePrefix(subnamePrefix);
        String result = instance.getSubnamePrefix();
        Assertions.assertEquals((Object)subnamePrefix, (Object)result);
    }

    @Test
    void testGetParameters() throws URISyntaxException, Exception {
        System.out.println("getParameters");
        DBURI instance = new DBURI(C_TEST_URI);
        HashMap<String, String> expResult = new HashMap<String, String>();
        expResult.put("param1", "x&1");
        expResult.put("param2", null);
        expResult.put("param3", null);
        Map result = instance.getParameters();
        Assertions.assertEquals(expResult, (Object)result);
    }

    @Test
    void testSetParameters() throws URISyntaxException, Exception {
        System.out.println("setParameters");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("param1", "x%FFF");
        parameters.put("param2", "IAmParameter2");
        parameters.put("param3", "IAmParameter3");
        DBURI instance = new DBURI(C_TEST_URI);
        instance.setParameters(parameters);
        Assertions.assertEquals(parameters, (Object)instance.getParameters());
    }

    @Test
    void testDefaultLanguagesList() throws URISyntaxException, Exception {
        System.out.println("testDefaultLanguagesList");
        List<String> defaultLanguagesList = Arrays.asList(C_DEFAULT_LANGUAGES.split(","));
        DBURI instance = new DBURI(C_TEST_DEFAULTS);
        List result = instance.getLanguagesList();
        Assertions.assertEquals(defaultLanguagesList, (Object)result);
    }

    @Test
    void testDefaultCharacterSet() throws URISyntaxException, Exception {
        System.out.println("testDefaultCharacterSet");
        DBURI instance = new DBURI(C_TEST_DEFAULTS);
        String result = instance.getCharacterSet();
        Assertions.assertEquals((Object)C_DEFAULT_CHARACTERSET, (Object)result);
    }

    @Test
    void testDefaultSchemasList() throws URISyntaxException, Exception {
        System.out.println("testDefaultSchemasList");
        List<String> defaultSchemasList = Arrays.asList(C_DEFAULT_SCHEMAS.split(","));
        DBURI instance = new DBURI(C_TEST_DEFAULTS);
        List result = instance.getSchemasList();
        Assertions.assertEquals(defaultSchemasList, (Object)result);
    }

    @Test
    void testDefaultSourceCodeTypesList() throws URISyntaxException, Exception {
        System.out.println("testDefaultSourceCodeTypesList");
        List<String> defaultSourceCodeTypesList = Arrays.asList(C_DEFAULT_SOURCE_CODE_TYPES.split(","));
        DBURI instance = new DBURI(C_TEST_DEFAULTS);
        List result = instance.getSourceCodeTypesList();
        Assertions.assertEquals(defaultSourceCodeTypesList, (Object)result);
    }

    @Test
    void testDefaultSourceCodeNamesList() throws URISyntaxException, Exception {
        System.out.println("testDefaultSourceCodeNamesList");
        List<String> defaultSourceCodeNamesList = Arrays.asList(C_DEFAULT_SOURCE_CODE_NAMES.split(","));
        DBURI instance = new DBURI(C_TEST_DEFAULTS);
        List result = instance.getSourceCodeNamesList();
        Assertions.assertEquals(defaultSourceCodeNamesList, (Object)result);
    }

    @Test
    void testExplicitLanguagesList() throws URISyntaxException, Exception {
        System.out.println("testExplicitLanguagesList");
        List<String> defaultLanguagesList = Arrays.asList(C_EXPLICIT_LANGUAGES.split(","));
        DBURI instance = new DBURI(C_TEST_EXPLICIT);
        List result = instance.getLanguagesList();
        Assertions.assertEquals(defaultLanguagesList, (Object)result);
    }

    @Test
    void testExplicitCharacterSet() throws URISyntaxException, Exception {
        System.out.println("testExplicitCharacterSet");
        DBURI instance = new DBURI(C_TEST_EXPLICIT);
        String result = instance.getCharacterSet();
        Assertions.assertEquals((Object)C_EXPLICIT_CHARACTERSET, (Object)result);
    }

    @Test
    void testExplicitSchemasList() throws URISyntaxException, Exception {
        System.out.println("testExplicitSchemasList");
        List<String> defaultSchemasList = Arrays.asList(C_EXPLICIT_SCHEMAS.split(","));
        DBURI instance = new DBURI(C_TEST_EXPLICIT);
        List result = instance.getSchemasList();
        Assertions.assertEquals(defaultSchemasList, (Object)result);
    }

    @Test
    void testExplicitSourceCodeTypesList() throws URISyntaxException, Exception {
        System.out.println("testExplicitSourceCodeTypesList");
        List<String> defaultSourceCodeTypesList = Arrays.asList(C_EXPLICIT_SOURCE_CODE_TYPES.split(","));
        DBURI instance = new DBURI(C_TEST_EXPLICIT);
        List result = instance.getSourceCodeTypesList();
        Assertions.assertEquals(defaultSourceCodeTypesList, (Object)result);
    }

    @Test
    void testExplicitSourceCodeNamesList() throws URISyntaxException, Exception {
        System.out.println("testExplicitSourceCodeNamesList");
        List<String> defaultSourceCodeNamesList = Arrays.asList(C_EXPLICIT_SOURCE_CODE_NAMES.split(","));
        DBURI instance = new DBURI(C_TEST_EXPLICIT);
        List result = instance.getSourceCodeNamesList();
        Assertions.assertEquals(defaultSourceCodeNamesList, (Object)result);
    }
}

