/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
class DBMSMetadataTest {
    private static final Logger LOG = LoggerFactory.getLogger(DBMSMetadataTest.class);
    static final String C_ORACLE_THIN_1 = "jdbc:oracle:thin:scott/tiger@//192.168.100.21:5521/customer_db?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25";
    static final String C_ORACLE_THIN_3 = "jdbc:oracle:thin:scott/oracle@//192.168.100.21:1521/orcl?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25";
    static final String C_ORACLE_THIN_4 = "jdbc:oracle:thin:system/oracle@//192.168.100.21:1521/ORCL?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25";
    static final String C_ORACLE_THIN_5 = "jdbc:oracle:thin:@//192.168.100.21:1521/ORCL?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25&amp;user=system&amp;password=oracle";
    static final String C_TEST_DEFAULTS = "jdbc:oracle:testdefault://192.168.100.21:1521/ORCL";
    private DBURI dbURI = new DBURI("jdbc:oracle:thin:scott/oracle@//192.168.100.21:1521/orcl?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25");
    private DBURI dbURI4 = new DBURI("jdbc:oracle:thin:system/oracle@//192.168.100.21:1521/ORCL?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25");
    private DBURI dbURI5 = new DBURI("jdbc:oracle:thin:@//192.168.100.21:1521/ORCL?characterset=utf8&schemas=scott,hr,sh,system&objectTypes=procedures,functions,triggers,package,types&languages=plsql,java&name=PKG_%25%7C%7CPRC_%25&amp;user=system&amp;password=oracle");
    private DBURI dbURIDefault = new DBURI("jdbc:oracle:testdefault://192.168.100.21:1521/ORCL");

    DBMSMetadataTest() throws URISyntaxException, Exception {
    }

    private static String getStringFromReader(Reader reader) throws IOException {
        int readChars;
        StringBuilder stringBuilder = new StringBuilder(1024);
        char[] charArray = new char[1024];
        while ((readChars = reader.read(charArray)) > 0) {
            System.out.println("Reader.read(CharArray)==" + readChars);
            stringBuilder.append(charArray, 0, readChars);
        }
        reader.close();
        return stringBuilder.toString();
    }

    private static void dumpResultSet(ResultSet resultSet, String description) {
        try {
            int columnNumber;
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            System.out.format("ResultSet \"%s\" has %d columns and contains ...\n[", description, columnCount);
            for (columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                System.out.format("%s%s", columnNumber > 1 ? "," : "", metaData.getColumnName(columnNumber));
            }
            System.out.format("\n", new Object[0]);
            while (resultSet.next()) {
                for (columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                    System.out.format("%s%s", columnNumber > 0 ? "," : "", resultSet.getString(columnNumber));
                }
                System.out.format("\n", new Object[0]);
            }
        }
        catch (SQLException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        System.out.format("...\n]\n", new Object[0]);
    }

    @Test
    void testGetConnection() throws Exception {
        System.out.println("getConnection");
        String driverClass = this.dbURI.getDriverClass();
        System.out.println("driverClass==" + driverClass);
        System.out.println("URL==" + this.dbURI.getURL());
        Class.forName(driverClass);
        Driver object = DriverManager.getDriver(this.dbURI.getURL());
        Properties properties = new Properties();
        properties.put("user", "system");
        properties.put("password", "oracle");
        Connection expResult = DriverManager.getDriver(this.dbURI.getURL()).connect(this.dbURI.getURL(), properties);
        DBMSMetadata instance = new DBMSMetadata(this.dbURI);
        Connection result = instance.getConnection();
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testGetConnectionWithConnectionParameters() throws Exception {
        System.out.println("getConnection");
        String driverClass = this.dbURI5.getDriverClass();
        System.out.println("driverClass==" + driverClass);
        System.out.println("URL==" + this.dbURI5.getURL());
        Class.forName(driverClass);
        Driver object = DriverManager.getDriver(this.dbURI5.getURL());
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.dbURI5.getParameters());
        Connection expResult = DriverManager.getDriver(this.dbURI5.getURL()).connect(this.dbURI5.getURL(), properties);
        DBMSMetadata instance = new DBMSMetadata(this.dbURI5);
        Connection result = instance.getConnection();
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testGetSourceCode() throws Exception {
        System.out.println("getSourceCode");
        String objectType = "TABLE";
        String name = "EMP";
        String schema = "SCOTT";
        System.out.println("dbURI.driverClass==" + this.dbURI.getDriverClass());
        System.out.println("dbURI.URL==" + this.dbURI.getURL());
        System.out.println("dbURI.getDBType.getProperties()==" + this.dbURI.getDbType().getProperties());
        System.out.println("dbURI.getDBType.getSourceCodeReturnType()==" + this.dbURI.getDbType().getSourceCodeReturnType());
        System.out.println("dbURI.getDBType.getProperties()==" + this.dbURI.getDbType().getProperties().getProperty("getSourceCodeStatement"));
        DBMSMetadata instance = new DBMSMetadata(this.dbURI);
        Object expResult = null;
        Reader result = instance.getSourceCode(objectType, name, schema);
        String resultString = DBMSMetadataTest.getStringFromReader(result);
        System.out.println("getSourceCode()==\"" + resultString);
    }

    @Test
    void testGetSchemas() throws Exception {
        System.out.println("getSchemas");
        DBURI testURI = this.dbURI4;
        String driverClass = testURI.getDriverClass();
        System.out.println("driverClass==" + driverClass);
        System.out.println("URL==" + testURI.getURL());
        Class.forName(driverClass);
        Driver object = DriverManager.getDriver(testURI.getURL());
        Properties properties = new Properties();
        properties.put("user", "system");
        properties.put("password", "oracle");
        Connection expResult = DriverManager.getDriver(testURI.getURL()).connect(testURI.getURL(), properties);
        DBMSMetadata instance = new DBMSMetadata(testURI);
        Connection result = instance.getConnection();
        Assertions.assertNotNull((Object)result);
        ResultSet allSchemas = result.getMetaData().getSchemas();
        DBMSMetadataTest.dumpResultSet(allSchemas, "All Schemas");
        ResultSet allCatalogues = result.getMetaData().getCatalogs();
        DBMSMetadataTest.dumpResultSet(allCatalogues, "All Catalogues");
        String catalog = null;
        String schemasPattern = "PHPDEMO";
        String tablesPattern = null;
        String proceduresPattern = null;
        ResultSet matchedTables = result.getMetaData().getTables(catalog, schemasPattern, tablesPattern, null);
        DBMSMetadataTest.dumpResultSet(matchedTables, "Matched Tables");
        ResultSet matchedProcedures = result.getMetaData().getProcedures(catalog, schemasPattern, proceduresPattern);
        DBMSMetadataTest.dumpResultSet(matchedProcedures, "Matched Procedures");
        System.out.format("testURI=%s,\ngetParameters()=%s\n", C_ORACLE_THIN_4, testURI.getParameters());
        System.out.format("testURI=%s,\ngetSchemasList()=%s\n,getSourceCodeTypesList()=%s\n,getSourceCodeNmesList()=%s\n", testURI, testURI.getSchemasList(), testURI.getSourceCodeTypesList(), testURI.getSourceCodeNamesList());
    }

    @Test
    void testGetSourceObjectList() throws Exception {
        System.out.println("getConnection");
        DBURI testURI = this.dbURI4;
        String driverClass = testURI.getDriverClass();
        System.out.println("driverClass==" + driverClass);
        System.out.println("URL==" + testURI.getURL());
        Class.forName(driverClass);
        Driver object = DriverManager.getDriver(testURI.getURL());
        Properties properties = new Properties();
        properties.put("user", "system");
        properties.put("password", "oracle");
        Connection expResult = DriverManager.getDriver(testURI.getURL()).connect(testURI.getURL(), properties);
        DBMSMetadata instance = new DBMSMetadata(testURI);
        Connection result = instance.getConnection();
        Assertions.assertNotNull((Object)result);
        List sourceObjectList = instance.getSourceObjectList();
        Assertions.assertNotNull((Object)sourceObjectList);
        System.out.format("testURI=%s,\ngetParameters()=%s\n", C_ORACLE_THIN_4, testURI.getParameters());
        System.out.format("testURI=%s,\ngetSchemasList()=%s\n,getSourceCodeTypesList()=%s\n,getSourceCodeNmesList()=%s\n", testURI, testURI.getSchemasList(), testURI.getSourceCodeTypesList(), testURI.getSourceCodeNamesList());
        System.out.print("sourceObjectList ...\n");
        for (SourceObject sourceObject : sourceObjectList) {
            System.out.printf("sourceObject=%s\n", sourceObject);
            System.out.printf("sourceCode=[%s]\n", DBMSMetadataTest.getStringFromReader(instance.getSourceCode(sourceObject)));
        }
    }
}

