/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.ParametricRuleViolation;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RuleViolationComparatorTest {
    RuleViolationComparatorTest() {
    }

    @Test
    void testComparator() {
        MockRule rule1 = PmdCoreTestUtils.setDummyLanguage(new MockRule("name1", "desc", "msg", "rulesetname1"));
        MockRule rule2 = PmdCoreTestUtils.setDummyLanguage(new MockRule("name2", "desc", "msg", "rulesetname2"));
        RuleViolation[] expectedOrder = new RuleViolation[12];
        int index = 0;
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file1", 10, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file1", 20, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file2", 10, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file2", 10, "desc2", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file3", 10, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file3", 10, "desc1", 10, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file4", 10, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file4", 10, "desc1", 1, 30, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file5", 10, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file5", 10, "desc1", 1, 20, 90);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule1, "file6", 10, "desc1", 1, 20, 80);
        expectedOrder[index++] = this.createJavaRuleViolation((Rule)rule2, "file6", 10, "desc1", 1, 20, 80);
        ArrayList<RuleViolation> ruleViolations = new ArrayList<RuleViolation>(Arrays.asList(expectedOrder));
        long seed = System.nanoTime();
        Random random = new Random(seed);
        Collections.shuffle(ruleViolations, random);
        Collections.sort(ruleViolations, RuleViolation.DEFAULT_COMPARATOR);
        int count = 0;
        for (int i = 0; i < expectedOrder.length; ++i) {
            ++count;
            Assertions.assertSame((Object)expectedOrder[i], ruleViolations.get(i), (String)("Wrong RuleViolation " + i + ", used seed: " + seed));
        }
        Assertions.assertEquals((int)expectedOrder.length, (int)count, (String)"Missing assertion for every RuleViolation");
    }

    private RuleViolation createJavaRuleViolation(Rule rule, String fileName, int beginLine, String description, int beginColumn, int endLine, int endColumn) {
        FileLocation loc = FileLocation.range((FileId)FileId.fromPathLikeString((String)fileName), (TextRange2d)TextRange2d.range2d((int)beginLine, (int)beginColumn, (int)endLine, (int)endColumn));
        return new ParametricRuleViolation(rule, loc, description, Collections.emptyMap());
    }
}

