/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.function.BiConsumer;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.TestMessageReporter;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.InternalApiBridge;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.log.PmdReporter;

public final class ReportTestUtil {
    private ReportTestUtil() {
    }

    public static Report getReport(Rule rule, BiConsumer<Rule, RuleContext> sideEffects) {
        return Report.buildReport(listener -> sideEffects.accept(rule, InternalApiBridge.createRuleContext((FileAnalysisListener)listener, (Rule)rule)));
    }

    public static Report getReportForRuleApply(Rule rule, Node node) {
        return ReportTestUtil.getReport(rule, (r, ctx) -> {
            r.initialize(node.getAstInfo().getLanguageProcessor());
            r.apply(node, ctx);
        });
    }

    public static Report getReportForRuleSetApply(RuleSet ruleset, RootNode node) {
        return Report.buildReport(listener -> {
            RuleSets ruleSets = new RuleSets(ruleset);
            LanguageProcessorRegistry registry = LanguageProcessorRegistry.singleton((LanguageProcessor)node.getAstInfo().getLanguageProcessor());
            ruleSets.initializeRules(registry, (PmdReporter)new TestMessageReporter());
            ruleSets.apply(node, listener);
        });
    }
}

