/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.InternalApiBridgeForTestsOnly;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.cache.internal.NoopAnalysisCache;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class GlobalAnalysisListenerTest {
    static final int NUM_DATA_SOURCES = 3;

    GlobalAnalysisListenerTest() {
    }

    @Test
    void testViolationCounter() {
        PMDConfiguration config = this.newConfig();
        GlobalAnalysisListener.ViolationCounterListener listener = new GlobalAnalysisListener.ViolationCounterListener();
        MyFooRule mockrule = (MyFooRule)((Object)Mockito.spy(MyFooRule.class));
        this.runPmd(config, (GlobalAnalysisListener)listener, (Rule)mockrule);
        ((MyFooRule)((Object)Mockito.verify((Object)((Object)mockrule), (VerificationMode)Mockito.times((int)3)))).apply((Node)ArgumentMatchers.any(), (RuleContext)ArgumentMatchers.any());
        Assertions.assertEquals((int)2, (int)((Integer)listener.getResult()));
    }

    @Test
    void testViolationCounterOnMulti() {
        PMDConfiguration config = this.newConfig();
        config.setThreads(2);
        GlobalAnalysisListener.ViolationCounterListener listener = new GlobalAnalysisListener.ViolationCounterListener();
        MyFooRule mockrule = (MyFooRule)((Object)Mockito.spy(MyFooRule.class));
        Mockito.when((Object)mockrule.deepCopy()).thenReturn((Object)mockrule);
        this.runPmd(config, (GlobalAnalysisListener)listener, (Rule)mockrule);
        ((MyFooRule)((Object)Mockito.verify((Object)((Object)mockrule), (VerificationMode)Mockito.times((int)3)))).apply((Node)ArgumentMatchers.any(), (RuleContext)ArgumentMatchers.any());
        Assertions.assertEquals((int)2, (int)((Integer)listener.getResult()));
    }

    @Test
    void testAnalysisCache() throws Exception {
        PMDConfiguration config = this.newConfig();
        AnalysisCache mockCache = (AnalysisCache)Mockito.spy(NoopAnalysisCache.class);
        InternalApiBridgeForTestsOnly.setAnalysisCache(config, mockCache);
        MyFooRule rule = new MyFooRule();
        this.runPmd(config, GlobalAnalysisListener.noop(), (Rule)rule);
        ((AnalysisCache)Mockito.verify((Object)mockCache)).checkValidity((RuleSets)ArgumentMatchers.any(), (ClassLoader)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ((AnalysisCache)Mockito.verify((Object)mockCache, (VerificationMode)Mockito.times((int)1))).persist();
        ((AnalysisCache)Mockito.verify((Object)mockCache, (VerificationMode)Mockito.times((int)3))).isUpToDate((TextDocument)ArgumentMatchers.any());
    }

    @Test
    void testCacheWithFailure() throws Exception {
        PMDConfiguration config = this.newConfig();
        AnalysisCache mockCache = (AnalysisCache)Mockito.spy(NoopAnalysisCache.class);
        InternalApiBridgeForTestsOnly.setAnalysisCache(config, mockCache);
        BrokenRule rule = new BrokenRule();
        this.runPmd(config, GlobalAnalysisListener.noop(), (Rule)rule);
        ((AnalysisCache)Mockito.verify((Object)mockCache)).checkValidity((RuleSets)ArgumentMatchers.any(), (ClassLoader)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ((AnalysisCache)Mockito.verify((Object)mockCache, (VerificationMode)Mockito.times((int)1))).persist();
        ((AnalysisCache)Mockito.verify((Object)mockCache, (VerificationMode)Mockito.times((int)3))).isUpToDate((TextDocument)ArgumentMatchers.any());
    }

    @Test
    void testCacheWithPropagatedException() throws Exception {
        PMDConfiguration config = this.newConfig();
        AnalysisCache mockCache = (AnalysisCache)Mockito.spy(NoopAnalysisCache.class);
        InternalApiBridgeForTestsOnly.setAnalysisCache(config, mockCache);
        BrokenRule rule = new BrokenRule();
        GlobalAnalysisListener listener = GlobalAnalysisListener.exceptionThrower();
        FileAnalysisException exception = (FileAnalysisException)Assertions.assertThrows(FileAnalysisException.class, () -> this.runPmd(config, listener, (Rule)rule));
        Assertions.assertEquals((Object)"fname1.dummy", (Object)exception.getFileId().getOriginalPath());
        ((AnalysisCache)Mockito.verify((Object)mockCache)).checkValidity((RuleSets)ArgumentMatchers.any(), (ClassLoader)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ((AnalysisCache)Mockito.verify((Object)mockCache, (VerificationMode)Mockito.times((int)1))).persist();
        ((AnalysisCache)Mockito.verify((Object)mockCache, (VerificationMode)Mockito.times((int)1))).isUpToDate((TextDocument)ArgumentMatchers.any());
    }

    private @NonNull PMDConfiguration newConfig() {
        PMDConfiguration config = new PMDConfiguration();
        config.setAnalysisCacheLocation(null);
        config.setIgnoreIncrementalAnalysis(true);
        config.setThreads(0);
        return config;
    }

    private void runPmd(PMDConfiguration config, GlobalAnalysisListener listener, Rule rule) {
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)rule));
            pmd.files().addSourceFile(FileId.fromPathLikeString((String)"fname1.dummy"), "abc");
            pmd.files().addSourceFile(FileId.fromPathLikeString((String)"fname2.dummy"), "abcd");
            pmd.files().addSourceFile(FileId.fromPathLikeString((String)"fname21.dummy"), "abcd");
            pmd.addListener(listener);
            pmd.performAnalysis();
        }
    }

    @Test
    void teeShouldForwardAllEventsSingleListeners() throws Exception {
        GlobalAnalysisListener mockListener1 = this.createMockListener();
        GlobalAnalysisListener teed = GlobalAnalysisListener.tee(Arrays.asList(mockListener1));
        teed.initializer();
        teed.startFileAnalysis(null);
        teed.onConfigError(null);
        teed.close();
        this.verifyMethods(mockListener1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockListener1});
    }

    @Test
    void teeShouldForwardAllEventsMultipleListeners() throws Exception {
        GlobalAnalysisListener mockListener1 = this.createMockListener();
        GlobalAnalysisListener mockListener2 = this.createMockListener();
        GlobalAnalysisListener teed = GlobalAnalysisListener.tee(Arrays.asList(mockListener1, mockListener2));
        teed.initializer();
        teed.startFileAnalysis(null);
        teed.onConfigError(null);
        teed.close();
        this.verifyMethods(mockListener1);
        this.verifyMethods(mockListener2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockListener1, mockListener2});
    }

    private GlobalAnalysisListener createMockListener() {
        GlobalAnalysisListener mockListener = (GlobalAnalysisListener)Mockito.mock(GlobalAnalysisListener.class);
        Mockito.when((Object)mockListener.initializer()).thenReturn((Object)ListenerInitializer.noop());
        Mockito.when((Object)mockListener.startFileAnalysis((TextFile)Mockito.any())).thenReturn((Object)FileAnalysisListener.noop());
        return mockListener;
    }

    private void verifyMethods(GlobalAnalysisListener listener) throws Exception {
        ((GlobalAnalysisListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).initializer();
        ((GlobalAnalysisListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).startFileAnalysis(null);
        ((GlobalAnalysisListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).onConfigError(null);
        ((GlobalAnalysisListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).close();
    }

    public static class BrokenRule
    extends FooRule {
        @Override
        public void apply(Node node, RuleContext ctx) {
            throw new IllegalArgumentException("Something happened");
        }
    }

    public static class MyFooRule
    extends FooRule {
        @Override
        public void apply(Node node, RuleContext ctx) {
            if (node.getTextDocument().getFileId().getFileName().contains("1")) {
                ctx.addViolation(node);
            }
        }
    }
}

