/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.RepeatedTest;

class DeterministicOutputListenerWrapperTest {
    DeterministicOutputListenerWrapperTest() {
    }

    @RepeatedTest(value=10)
    void testDeterministicOutputListener() {
        PMDConfiguration config = new PMDConfiguration();
        config.setAnalysisCacheLocation(null);
        config.setIgnoreIncrementalAnalysis(true);
        config.setThreads(6);
        MyRuleReportingAlways mockrule = new MyRuleReportingAlways();
        MyRendererSpy myRenderer = new MyRendererSpy();
        ArrayList<Object> fileIds = new ArrayList<Object>();
        int numFiles = 100;
        for (int i = 0; i < 100; ++i) {
            fileIds.add(FileId.fromPathLikeString((String)("file" + i + ".dummy")));
        }
        Collections.shuffle(fileIds);
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)mockrule));
            pmd.addRenderer((Renderer)myRenderer);
            for (FileId fileId : fileIds) {
                pmd.files().addSourceFile(fileId, "aoeuru uaoeru");
            }
            pmd.performAnalysis();
        }
        fileIds.sort(Comparator.naturalOrder());
        Assumptions.assumeFalse((boolean)mockrule.fileIds.equals(fileIds), (String)"Order of application of rules was same as sorted by chance");
        Assertions.assertEquals((int)100, (int)myRenderer.fileIds.size());
        Assertions.assertEquals(fileIds, myRenderer.fileIds);
    }

    static class MyRendererSpy
    extends AbstractIncrementingRenderer {
        List<FileId> fileIds = new ArrayList<FileId>();

        MyRendererSpy() {
            super("rendererspy", "description");
            this.setWriter(new PrintWriter(System.out));
        }

        public void renderFileViolations(Iterator<RuleViolation> violations) {
            this.fileIds.add(violations.next().getFileId());
        }

        public String defaultFileExtension() {
            return "";
        }
    }

    static class MyRuleReportingAlways
    extends FooRule {
        List<FileId> fileIds = new ArrayList<FileId>();

        MyRuleReportingAlways() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(Node node, RuleContext ctx) {
            ctx.addViolation(node);
            MyRuleReportingAlways myRuleReportingAlways = this;
            synchronized (myRuleReportingAlways) {
                this.fileIds.add(node.getTextDocument().getFileId());
            }
        }

        public Rule deepCopy() {
            return this;
        }
    }
}

