/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XMLRendererTest
extends AbstractRendererTest {
    @TempDir
    private Path folder;

    XMLRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        return new XMLRenderer();
    }

    @Override
    String getExpected() {
        return this.getHeader() + "<file name=\"" + this.getSourceCodeFilename() + "\">" + EOL + "<violation beginline=\"1\" endline=\"1\" begincolumn=\"1\" endcolumn=\"1\" rule=\"Foo\" ruleset=\"RuleSet\" priority=\"5\">" + EOL + "blah" + EOL + "</violation>" + EOL + "</file>" + EOL + "</pmd>" + EOL;
    }

    @Override
    String getExpectedEmpty() {
        return this.getHeader() + "</pmd>" + EOL;
    }

    @Override
    String getExpectedMultiple() {
        return this.getHeader() + "<file name=\"" + this.getSourceCodeFilename() + "\">" + EOL + "<violation beginline=\"1\" endline=\"1\" begincolumn=\"1\" endcolumn=\"1\" rule=\"Foo\" ruleset=\"RuleSet\" priority=\"5\">" + EOL + "blah" + EOL + "</violation>" + EOL + "<violation beginline=\"1\" endline=\"1\" begincolumn=\"1\" endcolumn=\"2\" rule=\"Boo\" ruleset=\"RuleSet\" priority=\"1\">" + EOL + "blah" + EOL + "</violation>" + EOL + "</file>" + EOL + "</pmd>" + EOL;
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        return this.getHeader() + "<error filename=\"file\" msg=\"RuntimeException: Error\">" + EOL + "<![CDATA[" + error.getDetail() + "]]>" + EOL + "</error>" + EOL + "</pmd>" + EOL;
    }

    @Override
    String getExpectedErrorWithoutMessage(Report.ProcessingError error) {
        return this.getHeader() + "<error filename=\"file\" msg=\"NullPointerException: null\">" + EOL + "<![CDATA[" + error.getDetail() + "]]>" + EOL + "</error>" + EOL + "</pmd>" + EOL;
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return this.getHeader() + "<configerror rule=\"Foo\" msg=\"a configuration error\"/>" + EOL + "</pmd>" + EOL;
    }

    @Override
    String filter(String expected) {
        return expected.replaceAll(" timestamp=\"[^\"]+\">", " timestamp=\"\">");
    }

    private RuleViolation createRuleViolation(String description) {
        FileLocation loc = FileLocation.range((FileId)FileId.fromPathLikeString((String)this.getSourceCodeFilename()), (TextRange2d)TextRange2d.range2d((int)1, (int)1, (int)1, (int)1));
        return this.newRuleViolation((Rule)new FooRule(), loc, description);
    }

    private void verifyXmlEscaping(Renderer renderer, String shouldContain, Charset charset) throws Exception {
        renderer.setProperty(XMLRenderer.ENCODING, (Object)charset.name());
        String surrogatePair = "\ud801\udc1c";
        String msg = "The String 'literal' \"Tok\u00e9niz\u0100r " + surrogatePair + "\" appears...";
        Report report = Report.buildReport(it -> it.onRuleViolation(this.createRuleViolation(msg)));
        String actual = this.renderTempFile(renderer, report, charset);
        Assertions.assertTrue((boolean)actual.contains(shouldContain));
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(actual)));
        NodeList violations = doc.getElementsByTagName("violation");
        Assertions.assertEquals((int)1, (int)violations.getLength());
        Assertions.assertEquals((Object)msg, (Object)violations.item(0).getTextContent().trim());
    }

    @Test
    void testXMLEscapingWithUTF8() throws Exception {
        Renderer renderer = this.getRenderer();
        this.verifyXmlEscaping(renderer, "\ud801\udc1c", StandardCharsets.UTF_8);
    }

    @Test
    void testXMLEscapingWithUTF16() throws Exception {
        Renderer renderer = this.getRenderer();
        this.verifyXmlEscaping(renderer, "&#x1041c;", StandardCharsets.UTF_16);
    }

    @Test
    void testXMLEscapingWithoutUTF8() throws Exception {
        Renderer renderer = this.getRenderer();
        this.verifyXmlEscaping(renderer, "&#x1041c;", StandardCharsets.ISO_8859_1);
    }

    String getHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + EOL + "<pmd xmlns=\"http://pmd.sourceforge.net/report/2.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://pmd.sourceforge.net/report/2.0.0 https://pmd.github.io/schema/report_2_0_0.xsd\" version=\"" + PMDVersion.VERSION + "\" timestamp=\"2014-10-06T19:30:51.262\">" + EOL;
    }

    @Test
    void testCorrectCharset() throws Exception {
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty("file.encoding", StandardCharsets.ISO_8859_1.name());
            Renderer renderer = this.getRenderer();
            String formFeed = "\f";
            String specialChars = "\u00e9\u0100";
            String originalChars = formFeed + specialChars;
            String msg = "The String literal \"" + originalChars + "\" appears...";
            Report report = Report.buildReport(it -> it.onRuleViolation(this.createRuleViolation(msg)));
            String actual = this.renderTempFile(renderer, report, StandardCharsets.UTF_8);
            Assertions.assertTrue((boolean)actual.contains(specialChars));
            Assertions.assertFalse((boolean)actual.contains(formFeed));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(actual)));
            NodeList violations = doc.getElementsByTagName("violation");
            Assertions.assertEquals((int)1, (int)violations.getLength());
            Assertions.assertEquals((Object)msg.replaceAll(formFeed, ""), (Object)violations.item(0).getTextContent().trim());
        });
    }

    @Test
    void cdataSectionInError() throws Exception {
        Report.ProcessingError processingError = new Report.ProcessingError((Throwable)new ParseException("Invalid source: '<![CDATA[ ... ]]> ...'"), FileId.fromPathLikeString((String)"dummy.txt"));
        String result = this.renderReport(this.getRenderer(), it -> it.onError(processingError), StandardCharsets.UTF_8);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Assertions.assertDoesNotThrow(() -> documentBuilder.parse(new InputSource(new StringReader(result))));
    }

    private String renderTempFile(Renderer renderer, Report report, Charset expectedCharset) throws IOException {
        File reportFile = this.folder.resolve("report.out").toFile();
        renderer.setReportFile(reportFile.getAbsolutePath());
        renderer.start();
        renderer.renderFileReport(report);
        renderer.end();
        renderer.flush();
        try (FileInputStream input = new FileInputStream(reportFile);){
            String string = IOUtil.readToString((InputStream)input, (Charset)expectedCharset);
            return string;
        }
    }
}

