/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextColorRenderer;
import net.sourceforge.pmd.reporting.Report;

class TextColorRendererTest
extends AbstractRendererTest {
    TextColorRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        TextColorRenderer result = new TextColorRenderer(){

            protected Reader getReader(String sourceFile) throws FileNotFoundException {
                return new StringReader("public class Foo {}");
            }
        };
        return result;
    }

    @Override
    String getExpected() {
        return "\u001b[1;33m*\u001b[0m file: \u001b[1;37m" + this.getSourceCodeFilename() + "\u001b[0m" + EOL + "\u001b[0;32m    src:  \u001b[0;36m" + this.getSourceCodeFilename() + "\u001b[0m:\u001b[0;36m1:1\u001b[0m" + EOL + "\u001b[0;32m    rule: \u001b[0mFoo" + EOL + "\u001b[0;32m    msg:  \u001b[0mblah" + EOL + "\u001b[0;32m    code: \u001b[0mpublic class Foo {}" + EOL + EOL + EOL + EOL + "Summary:" + EOL + EOL + "\u001b[1;33m*\u001b[0m warnings: \u001b[1;37m1\u001b[0m" + EOL;
    }

    @Override
    String getExpectedEmpty() {
        return EOL + EOL + "Summary:" + EOL + EOL + "\u001b[1;33m*\u001b[0m warnings: \u001b[1;37m0\u001b[0m" + EOL;
    }

    @Override
    String getExpectedMultiple() {
        return "\u001b[1;33m*\u001b[0m file: \u001b[1;37m" + this.getSourceCodeFilename() + "\u001b[0m" + EOL + "\u001b[0;32m    src:  \u001b[0;36m" + this.getSourceCodeFilename() + "\u001b[0m:\u001b[0;36m1:1\u001b[0m" + EOL + "\u001b[0;32m    rule: \u001b[0mFoo" + EOL + "\u001b[0;32m    msg:  \u001b[0mblah" + EOL + "\u001b[0;32m    code: \u001b[0mpublic class Foo {}" + EOL + "" + EOL + "\u001b[0;32m    src:  \u001b[0;36m" + this.getSourceCodeFilename() + "\u001b[0m:\u001b[0;36m1:1\u001b[0m" + EOL + "\u001b[0;32m    rule: \u001b[0mBoo" + EOL + "\u001b[0;32m    msg:  \u001b[0mblah" + EOL + "\u001b[0;32m    code: \u001b[0mpublic class Foo {}" + EOL + EOL + EOL + EOL + "Summary:" + EOL + EOL + "\u001b[1;33m*\u001b[0m warnings: \u001b[1;37m2\u001b[0m" + EOL;
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        return EOL + EOL + "Summary:" + EOL + EOL + "\u001b[1;31m*\u001b[0m file: \u001b[1;37mfile\u001b[0m" + EOL + "\u001b[0;32m    err:  \u001b[0;36mRuntimeException: Error\u001b[0m" + EOL + "\u001b[0;31m" + error.getDetail() + "\u001b[0m" + EOL + EOL + "\u001b[1;31m*\u001b[0m errors:   \u001b[1;37m1\u001b[0m" + EOL + "\u001b[1;33m*\u001b[0m warnings: \u001b[1;37m0\u001b[0m" + EOL;
    }

    @Override
    String getExpectedErrorWithoutMessage(Report.ProcessingError error) {
        return EOL + EOL + "Summary:" + EOL + EOL + "\u001b[1;31m*\u001b[0m file: \u001b[1;37mfile\u001b[0m" + EOL + "\u001b[0;32m    err:  \u001b[0;36mNullPointerException: null\u001b[0m" + EOL + "\u001b[0;31m" + error.getDetail() + "\u001b[0m" + EOL + EOL + "\u001b[1;31m*\u001b[0m errors:   \u001b[1;37m1\u001b[0m" + EOL + "\u001b[1;33m*\u001b[0m warnings: \u001b[1;37m0\u001b[0m" + EOL;
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return EOL + EOL + "Summary:" + EOL + EOL + "\u001b[1;31m*\u001b[0m rule: \u001b[1;37mFoo\u001b[0m" + EOL + "\u001b[0;32m    err:  \u001b[0;36ma configuration error\u001b[0m" + EOL + EOL + "\u001b[1;31m*\u001b[0m errors:   \u001b[1;37m1\u001b[0m" + EOL + "\u001b[1;33m*\u001b[0m warnings: \u001b[1;37m0\u001b[0m" + EOL;
    }
}

