/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.SarifRenderer;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SarifRendererTest
extends AbstractRendererTest {
    SarifRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        return new SarifRenderer();
    }

    @Test
    void testRendererWithASCII() throws Exception {
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty("file.encoding", StandardCharsets.US_ASCII.name());
            this.testRenderer(StandardCharsets.UTF_8);
        });
    }

    @Override
    String getExpected() {
        return this.readFile("expected.sarif.json");
    }

    @Override
    String getExpectedEmpty() {
        return this.readFile("empty.sarif.json");
    }

    @Override
    String getExpectedMultiple() {
        return this.readFile("expected-multiple.sarif.json");
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        String expected = this.readFile("expected-error.sarif.json");
        expected = expected.replace("###REPLACE_ME###", error.getDetail().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
        return expected;
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return this.readFile("expected-configerror.sarif.json");
    }

    @Override
    String getExpectedErrorWithoutMessage(Report.ProcessingError error) {
        String expected = this.readFile("expected-error-nomessage.sarif.json");
        expected = expected.replace("###REPLACE_ME###", error.getDetail().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
        return expected;
    }

    @Override
    String filter(String expected) {
        return expected.replaceAll("\r\n", "\n").replaceAll("\"version\": \".+\",", "\"version\": \"unknown\",");
    }

    @Test
    void testRendererMultipleLocations() throws Exception {
        String actual = this.renderReport(this.getRenderer(), this.reportThreeViolationsTwoRules());
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(actual, JsonObject.class);
        JsonArray results = json.getAsJsonArray("runs").get(0).getAsJsonObject().getAsJsonArray("results");
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals((Object)this.filter(this.readFile("expected-multiple-locations.sarif.json")), (Object)this.filter(actual));
    }

    private Consumer<FileAnalysisListener> reportThreeViolationsTwoRules() {
        Rule fooRule = this.createFooRule();
        Rule booRule = this.createBooRule();
        return reportBuilder -> {
            reportBuilder.onRuleViolation(this.newRuleViolation(1, 1, 1, 10, fooRule));
            reportBuilder.onRuleViolation(this.newRuleViolation(5, 1, 5, 11, fooRule));
            reportBuilder.onRuleViolation(this.newRuleViolation(2, 2, 3, 1, booRule));
        };
    }

    @Override
    protected String readFile(String relativePath) {
        return super.readFile("sarif/" + relativePath);
    }
}

