/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Optional;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.Report;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HTMLRendererTest
extends AbstractRendererTest {
    HTMLRendererTest() {
    }

    @Override
    protected String getSourceCodeFilename() {
        return "someFilename\u00a0thatNeedsEscaping.ext";
    }

    private String getEscapedFilename() {
        return "someFilename&nbsp;thatNeedsEscaping.ext";
    }

    @Override
    Renderer getRenderer() {
        return new HTMLRenderer();
    }

    @Override
    String getExpected() {
        return this.getExpected(null, null);
    }

    private String getExpected(String linkPrefix, String lineAnchor) {
        String filename = this.getEscapedFilename();
        if (linkPrefix != null) {
            filename = "<a href=\"" + linkPrefix + filename + "#" + lineAnchor + "\">" + filename + "</a>";
        }
        return this.getHeader() + "<tr bgcolor=\"lightgrey\"> " + EOL + "<td align=\"center\">1</td>" + EOL + "<td width=\"*%\">" + filename + "</td>" + EOL + "<td align=\"center\" width=\"5%\">1</td>" + EOL + "<td width=\"*\">blah</td>" + EOL + "</tr>" + EOL + "</table></body></html>" + EOL;
    }

    @Override
    String getExpectedEmpty() {
        return this.getHeader() + "</table></body></html>" + EOL;
    }

    @Override
    String getExpectedMultiple() {
        return this.getHeader() + "<tr bgcolor=\"lightgrey\"> " + EOL + "<td align=\"center\">1</td>" + EOL + "<td width=\"*%\">" + this.getEscapedFilename() + "</td>" + EOL + "<td align=\"center\" width=\"5%\">1</td>" + EOL + "<td width=\"*\">blah</td>" + EOL + "</tr>" + EOL + "<tr> " + EOL + "<td align=\"center\">2</td>" + EOL + "<td width=\"*%\">" + this.getEscapedFilename() + "</td>" + EOL + "<td align=\"center\" width=\"5%\">1</td>" + EOL + "<td width=\"*\">blah</td>" + EOL + "</tr>" + EOL + "</table></body></html>" + EOL;
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        return this.getHeader() + "</table><hr/><center><h3>Processing errors</h3></center><table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + EOL + "<th>File</th><th>Problem</th></tr>" + EOL + "<tr bgcolor=\"lightgrey\"> " + EOL + "<td>file</td>" + EOL + "<td><pre>" + error.getDetail() + "</pre></td>" + EOL + "</tr>" + EOL + "</table></body></html>" + EOL;
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return this.getHeader() + "</table><hr/><center><h3>Configuration errors</h3></center><table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + EOL + "<th>Rule</th><th>Problem</th></tr>" + EOL + "<tr bgcolor=\"lightgrey\"> " + EOL + "<td>Foo</td>" + EOL + "<td>a configuration error</td>" + EOL + "</tr>" + EOL + "</table></body></html>" + EOL;
    }

    private String getHeader() {
        return "<html><head><title>PMD</title></head><body>" + EOL + "<center><h3>PMD report</h3></center><center><h3>Problems found</h3></center><table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + EOL;
    }

    @Test
    void testLinkPrefix() throws IOException {
        HTMLRenderer renderer = new HTMLRenderer();
        String linkPrefix = "https://github.com/pmd/pmd/blob/main/";
        String linePrefix = "L";
        renderer.setProperty(HTMLRenderer.LINK_PREFIX, (Object)"https://github.com/pmd/pmd/blob/main/");
        renderer.setProperty(HTMLRenderer.LINE_PREFIX, Optional.of("L"));
        renderer.setProperty(HTMLRenderer.HTML_EXTENSION, (Object)false);
        String actual = this.renderReport((Renderer)renderer, this.reportOneViolation());
        Assertions.assertEquals((Object)this.filter(this.getExpected("https://github.com/pmd/pmd/blob/main/", "L1")), (Object)this.filter(actual));
    }

    @Test
    void testLinePrefixNotSet() throws IOException {
        HTMLRenderer renderer = new HTMLRenderer();
        String linkPrefix = "https://github.com/pmd/pmd/blob/main/";
        renderer.setProperty(HTMLRenderer.LINK_PREFIX, (Object)"https://github.com/pmd/pmd/blob/main/");
        renderer.setProperty(HTMLRenderer.HTML_EXTENSION, (Object)false);
        String actual = this.renderReport((Renderer)renderer, this.reportOneViolation());
        Assertions.assertEquals((Object)this.filter(this.getExpected("https://github.com/pmd/pmd/blob/main/", "")), (Object)this.filter(actual));
    }

    @Test
    void testEmptyLinePrefix() throws IOException {
        HTMLRenderer renderer = new HTMLRenderer();
        String linkPrefix = "https://github.com/pmd/pmd/blob/main/";
        renderer.setProperty(HTMLRenderer.LINK_PREFIX, (Object)"https://github.com/pmd/pmd/blob/main/");
        renderer.setProperty(HTMLRenderer.LINE_PREFIX, Optional.of(""));
        renderer.setProperty(HTMLRenderer.HTML_EXTENSION, (Object)false);
        String actual = this.renderReport((Renderer)renderer, this.reportOneViolation());
        Assertions.assertEquals((Object)this.filter(this.getExpected("https://github.com/pmd/pmd/blob/main/", "1")), (Object)this.filter(actual));
    }
}

