/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.function.Consumer;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.RuleWithProperties;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.InternalApiBridge;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

abstract class AbstractRendererTest {
    @RegisterExtension
    protected final DummyParsingHelper helper = new DummyParsingHelper();
    protected static final String EOL = System.lineSeparator();
    @TempDir
    private Path tempDir;

    AbstractRendererTest() {
    }

    abstract Renderer getRenderer();

    abstract String getExpected();

    String getExpectedWithProperties() {
        return this.getExpected();
    }

    abstract String getExpectedEmpty();

    abstract String getExpectedMultiple();

    String getExpectedError(Report.ProcessingError error) {
        return "";
    }

    String getExpectedErrorWithoutMessage(Report.ProcessingError error) {
        return this.getExpectedError(error);
    }

    String getExpectedError(Report.ConfigurationError error) {
        return "";
    }

    String filter(String expected) {
        return expected;
    }

    String getSourceCodeFilename() {
        return "notAvailable.ext";
    }

    @Test
    void testNullPassedIn() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> this.getRenderer().renderFileReport(null));
    }

    protected Consumer<FileAnalysisListener> reportOneViolation() {
        return it -> it.onRuleViolation(this.newRuleViolation(1, 1, 1, 1, this.createFooRule()));
    }

    private Consumer<FileAnalysisListener> reportTwoViolations() {
        return it -> {
            RuleViolation informationalRuleViolation = this.newRuleViolation(1, 1, 1, 1, this.createFooRule());
            it.onRuleViolation(informationalRuleViolation);
            RuleViolation severeRuleViolation = this.newRuleViolation(1, 1, 1, 2, this.createBooRule());
            it.onRuleViolation(severeRuleViolation);
        };
    }

    protected FileLocation createLocation(int beginLine, int beginColumn, int endLine, int endColumn) {
        TextRange2d range2d = TextRange2d.range2d((int)beginLine, (int)beginColumn, (int)endLine, (int)endColumn);
        return FileLocation.range((FileId)FileId.fromPathLikeString((String)this.getSourceCodeFilename()), (TextRange2d)range2d);
    }

    protected RuleViolation newRuleViolation(int beginLine, int beginColumn, int endLine, int endColumn, Rule rule) {
        FileLocation loc = this.createLocation(beginLine, beginColumn, endLine, endColumn);
        return this.newRuleViolation(rule, loc, "blah");
    }

    protected RuleViolation newRuleViolation(Rule rule, FileLocation location, String message) {
        return InternalApiBridge.createRuleViolation((Rule)rule, (FileLocation)location, (String)message, Collections.emptyMap());
    }

    protected Rule createBooRule() {
        FooRule booRule = new FooRule();
        booRule.setName("Boo");
        booRule.setDescription("desc");
        booRule.setPriority(RulePriority.HIGH);
        return booRule;
    }

    protected Rule createFooRule() {
        FooRule fooRule = new FooRule();
        fooRule.setName("Foo");
        fooRule.setPriority(RulePriority.LOW);
        return fooRule;
    }

    protected String readFile(String relativePath) {
        String string;
        block8: {
            InputStream in = this.getClass().getResourceAsStream(relativePath);
            try {
                string = IOUtil.readToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return string;
    }

    @Test
    void testRuleWithProperties() throws Exception {
        RuleWithProperties theRule = new RuleWithProperties();
        theRule.setProperty(RuleWithProperties.STRING_PROPERTY_DESCRIPTOR, "the string value\nsecond line with \"quotes\"");
        RuleViolation violation = this.newRuleViolation(1, 1, 1, 1, (Rule)theRule);
        String rendered = this.renderReport(this.getRenderer(), it -> it.onRuleViolation(violation));
        Assertions.assertEquals((Object)this.filter(this.getExpectedWithProperties()), (Object)this.filter(rendered));
    }

    @Test
    void testRenderer() throws Exception {
        this.testRenderer(Charset.defaultCharset());
    }

    protected void testRenderer(Charset expectedCharset) throws Exception {
        String actual = this.renderReport(this.getRenderer(), this.reportOneViolation(), expectedCharset);
        Assertions.assertEquals((Object)this.filter(this.getExpected()), (Object)this.filter(actual));
    }

    @Test
    void testRendererEmpty() throws Exception {
        String actual = this.render(it -> {});
        Assertions.assertEquals((Object)this.filter(this.getExpectedEmpty()), (Object)this.filter(actual));
    }

    @Test
    void testRendererMultiple() throws Exception {
        String actual = this.render(this.reportTwoViolations());
        Assertions.assertEquals((Object)this.filter(this.getExpectedMultiple()), (Object)this.filter(actual));
    }

    @Test
    void testError() throws Exception {
        Report.ProcessingError err = new Report.ProcessingError((Throwable)new RuntimeException("Error"), FileId.fromPathLikeString((String)"file"));
        String actual = this.render(it -> it.onError(err));
        Assertions.assertEquals((Object)this.filter(this.getExpectedError(err)), (Object)this.filter(actual));
    }

    @Test
    void testErrorWithoutMessage() throws Exception {
        Report.ProcessingError err = new Report.ProcessingError((Throwable)new NullPointerException(), FileId.fromPathLikeString((String)"file"));
        String actual = this.render(it -> it.onError(err));
        Assertions.assertEquals((Object)this.filter(this.getExpectedErrorWithoutMessage(err)), (Object)this.filter(actual));
    }

    private String render(Consumer<FileAnalysisListener> listenerEffects) throws IOException {
        return this.renderReport(this.getRenderer(), listenerEffects);
    }

    @Test
    void testConfigError() throws Exception {
        Report.ConfigurationError err = new Report.ConfigurationError((Rule)new FooRule(), "a configuration error");
        String actual = this.renderGlobal(this.getRenderer(), it -> it.onConfigError(err));
        Assertions.assertEquals((Object)this.filter(this.getExpectedError(err)), (Object)this.filter(actual));
    }

    protected String renderReport(Renderer renderer, Consumer<? super FileAnalysisListener> listenerEffects) throws IOException {
        return this.renderReport(renderer, listenerEffects, Charset.defaultCharset());
    }

    protected String renderReport(Renderer renderer, Consumer<? super FileAnalysisListener> listenerEffects, Charset expectedEncoding) throws IOException {
        return this.renderGlobal(renderer, globalListener -> {
            LanguageVersion version = DummyLanguageModule.getInstance().getDefaultVersion();
            TextFile dummyFile = TextFile.forCharSeq((CharSequence)"dummyText", (FileId)FileId.fromPathLikeString((String)"fname1.dummy"), (LanguageVersion)version);
            try (FileAnalysisListener fal = globalListener.startFileAnalysis(dummyFile);){
                listenerEffects.accept(fal);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }, expectedEncoding);
    }

    private String renderGlobal(Renderer renderer, Consumer<? super GlobalAnalysisListener> listenerEffects) throws IOException {
        return this.renderGlobal(renderer, listenerEffects, Charset.defaultCharset());
    }

    private String renderGlobal(Renderer renderer, Consumer<? super GlobalAnalysisListener> listenerEffects, Charset expectedEncoding) throws IOException {
        File file = this.tempDir.resolve("report.out").toFile();
        renderer.setReportFile(file.getAbsolutePath());
        try (GlobalAnalysisListener listener = renderer.newListener();){
            listenerEffects.accept((GlobalAnalysisListener)listener);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return IOUtil.readFileToString((File)file, (Charset)expectedEncoding);
    }
}

