/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulesetFactoryTestBase;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PropertySyntaxTest
extends RulesetFactoryTestBase {
    PropertySyntaxTest() {
    }

    private PropertyDescriptor<?> defineProperty(String propDef) {
        Rule rule = this.loadFirstRule(PropertySyntaxTest.contextForPropertyDef(propDef));
        ArrayList descriptors = new ArrayList(rule.getPropertyDescriptors());
        descriptors.removeAll(CollectionUtil.setOf((Object)Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR, (Object[])new PropertyDescriptor[]{Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR}));
        return (PropertyDescriptor)descriptors.get(0);
    }

    private static String contextForPropertyDef(String propDef) {
        return PropertySyntaxTest.rulesetXml(PropertySyntaxTest.dummyRule(PropertySyntaxTest.properties(propDef)));
    }

    @Test
    void testPropDefXml() {
        PropertyDescriptor<?> prop = this.defineProperty(PropertySyntaxTest.propertyDefWithValueAttr("pname", "pdesc", "String", "strvalue"));
        Assertions.assertEquals((Object)"pname", (Object)prop.name());
        Assertions.assertEquals((Object)"strvalue", (Object)prop.defaultValue());
    }

    @Test
    void testNumericPropDefWithoutBounds() {
        PropertyDescriptor<?> prop = this.defineProperty("<property name='pname' description='d' type='Integer' value='4' />");
        Assertions.assertEquals((Object)"pname", (Object)prop.name());
        Assertions.assertEquals((Object)4, (Object)prop.defaultValue());
        Assertions.assertEquals((Object)CollectionUtil.emptyList(), (Object)prop.serializer().getConstraints());
    }

    @Test
    void testNumericPropDefWithMinBound() {
        PropertyDescriptor<?> prop = this.defineProperty("<property name='pname' description='d' type='Integer' value='4' min='1' />");
        Assertions.assertEquals((Object)"pname", (Object)prop.name());
        Assertions.assertEquals((Object)4, (Object)prop.defaultValue());
        Assertions.assertEquals((int)1, (int)prop.serializer().getConstraints().size());
        Assertions.assertEquals((Object)"Should be greater or equal to 1", (Object)((PropertyConstraint)prop.serializer().getConstraints().get(0)).getConstraintDescription());
    }

    @Test
    void testNumericPropDefWithMaxBound() {
        PropertyDescriptor<?> prop = this.defineProperty("<property name='pname' description='d' type='Integer' value='4' max='6' />");
        Assertions.assertEquals((Object)"Should be smaller or equal to 6", (Object)((PropertyConstraint)prop.serializer().getConstraints().get(0)).getConstraintDescription());
    }

    @Test
    void testNumericPropDefWithMaxAndMin() {
        PropertyDescriptor<?> prop = this.defineProperty("<property name='pname' description='d' type='Integer' value='4' max='6' min='2' />");
        Assertions.assertEquals((Object)"Should be between 2 and 6", (Object)((PropertyConstraint)prop.serializer().getConstraints().get(0)).getConstraintDescription());
    }

    @Test
    void testNumericPropDefWithMaxAndMinUnordered() {
        this.assertCannotParse(PropertySyntaxTest.contextForPropertyDef("<property name='pname' description='d' type='Integer' value='4' max='6' min='12' />"));
        this.verifyFoundAnErrorWithMessage(PropertySyntaxTest.containing("Minimum value should be lower than maximum value"));
    }

    @Test
    void testNumericPropConstraintViolated() {
        this.assertCannotParse(PropertySyntaxTest.contextForPropertyDef("<property name='pname' description='d' type='Integer' value='4' max='1' />"));
        this.verifyFoundAnErrorWithMessage(PropertySyntaxTest.containing("'4' should be smaller or equal to 1"));
    }

    @Test
    void testStringProp() {
        this.assertValueRoundTrip((PropertySerializer)PropertyParsingUtil.STRING, "ad", (Object)"ad");
        this.assertValueRoundTrip((PropertySerializer)PropertyParsingUtil.STRING, "", (Object)"");
    }

    @Test
    void testStringListProp() {
        this.assertValueRoundTrip(PropertyParsingUtil.STRING_LIST, "ad,j", CollectionUtil.listOf((Object)"ad", (Object[])new String[]{"j"}));
    }

    private <T> void assertValueRoundTrip(PropertySerializer<T> mapper, String input, T expected) {
        Object parsed = mapper.fromString(input);
        Assertions.assertEquals(expected, (Object)parsed, (String)"fromString");
        String str = mapper.toString(parsed);
        Assertions.assertEquals((Object)input, (Object)str, (String)"toString");
    }
}

