/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.symboltable;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.sourceforge.pmd.lang.symboltable.Applier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ApplierTest {
    ApplierTest() {
    }

    @Test
    void testSimple() {
        MyFunction f = new MyFunction(Integer.MAX_VALUE);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new Object());
        l.add(new Object());
        l.add(new Object());
        Applier.apply((Predicate)f, l.iterator());
        Assertions.assertEquals((int)l.size(), (int)f.getNumCallbacks());
    }

    @Test
    void testLimit() {
        MyFunction f = new MyFunction(2);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new Object());
        l.add(new Object());
        l.add(new Object());
        Applier.apply((Predicate)f, l.iterator());
        Assertions.assertEquals((int)2, (int)f.getNumCallbacks());
    }

    private static class MyFunction
    implements Predicate<Object> {
        private int numCallbacks = 0;
        private final int maxCallbacks;

        MyFunction(int maxCallbacks) {
            this.maxCallbacks = maxCallbacks;
        }

        @Override
        public boolean test(Object o) {
            ++this.numCallbacks;
            return this.numCallbacks < this.maxCallbacks;
        }

        public int getNumCallbacks() {
            return this.numCallbacks;
        }
    }
}

