/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.impl.AttributeAxisIterator;
import net.sourceforge.pmd.lang.rule.xpath.impl.dummyast.ConcreteNode;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AttributeAxisIteratorTest {
    private static final Set<String> DEFAULT_ATTRS = CollectionUtil.setOf((Object)"BeginColumn", (Object[])new String[]{"BeginLine", "Image", "EndColumn", "EndLine"});

    AttributeAxisIteratorTest() {
    }

    @Test
    void testAttributeAxisIterator() {
        DummyNode dummyNode = new DummyNode();
        AttributeAxisIterator it = new AttributeAxisIterator((Node)dummyNode);
        Set expected = CollectionUtil.setUnion(DEFAULT_ATTRS, (Object)"Lines", (Object[])new String[0]);
        Assertions.assertEquals((Object)expected, this.toMap(it).keySet());
    }

    @Test
    void testAttributeAxisIteratorWithEnum() {
        DummyNodeWithEnum dummyNode = new DummyNodeWithEnum();
        AttributeAxisIterator it = new AttributeAxisIterator((Node)dummyNode);
        Set expected = CollectionUtil.setUnion(DEFAULT_ATTRS, (Object)"Enum", (Object[])new String[]{"Lines"});
        Assertions.assertEquals((Object)expected, this.toMap(it).keySet());
    }

    @Test
    void testAttributeAxisIteratorWithList() {
        DummyNodeWithList dummyNode = new DummyNodeWithList();
        AttributeAxisIterator it = new AttributeAxisIterator((Node)dummyNode);
        Set expected = CollectionUtil.setUnion(DEFAULT_ATTRS, (Object)"List", (Object[])new String[]{"Lines"});
        Assertions.assertEquals((Object)expected, this.toMap(it).keySet());
    }

    @Test
    void accessPublicMethodWithAPackagePrivateImplementationInSuperclass() {
        String ATTRIBUTE_NAME = "Value";
        ConcreteNode node = new ConcreteNode();
        AttributeAxisIterator it = new AttributeAxisIterator((Node)node);
        Map<String, Attribute> attributes = this.toMap(it);
        Assertions.assertTrue((boolean)attributes.containsKey("Value"));
        Assertions.assertEquals((Object)"actual_value", (Object)attributes.get("Value").getValue().toString());
    }

    private Map<String, Attribute> toMap(AttributeAxisIterator it) {
        HashMap<String, Attribute> atts = new HashMap<String, Attribute>();
        while (it.hasNext()) {
            Attribute attribute = it.next();
            atts.put(attribute.getName(), attribute);
        }
        return atts;
    }

    public static class DummyNodeWithList
    extends DummyNode {
        public List<String> getList() {
            return Arrays.asList("A", "B");
        }

        public List<Node> getNodeList() {
            return Collections.emptyList();
        }
    }

    public static class DummyNodeWithEnum
    extends DummyNode {
        public MyEnum getEnum() {
            return MyEnum.FOO;
        }

        public static enum MyEnum {
            FOO,
            BAR;

        }
    }
}

