/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.rule.MockRuleWithNoProperties;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.xml.SchemaConstant;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;
import net.sourceforge.pmd.util.log.PmdReporter;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class RulesetFactoryTestBase {
    protected PmdReporter mockReporter;

    @BeforeEach
    void setup() {
        SimpleMessageReporter reporter = new SimpleMessageReporter(LoggerFactory.getLogger(RulesetFactoryTestBase.class));
        this.mockReporter = (PmdReporter)Mockito.spy((Object)reporter);
    }

    protected void verifyNoWarnings() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockReporter});
    }

    protected static Predicate<String> containing(final String part) {
        return new Predicate<String>(){

            @Override
            public boolean test(String it) {
                String format = MessageFormat.format(it, new Object[0]);
                return format.contains(part);
            }

            public String toString() {
                return "string containing: " + part;
            }
        };
    }

    protected void verifyFoundAWarningWithMessage(Predicate<String> messageTest) {
        this.verifyFoundWarningWithMessage(Mockito.times((int)1), messageTest);
    }

    protected void verifyFoundWarningWithMessage(VerificationMode mode, Predicate<String> messageTest) {
        ((PmdReporter)Mockito.verify((Object)this.mockReporter, (VerificationMode)mode)).logEx((Level)Mockito.eq((Object)Level.WARN), (String)Mockito.argThat(messageTest::test), (Object[])Mockito.any(), (Throwable)Mockito.any());
    }

    protected void verifyFoundAnErrorWithMessage(Predicate<String> messageTest) {
        ((PmdReporter)Mockito.verify((Object)this.mockReporter, (VerificationMode)Mockito.times((int)1))).logEx((Level)Mockito.eq((Object)Level.ERROR), (String)Mockito.argThat(messageTest::test), (Object[])Mockito.any(), (Throwable)Mockito.any());
    }

    protected RuleSet loadRuleSetInDir(String resourceDir, String ruleSetFilename) {
        RuleSetLoader loader = new RuleSetLoader().withReporter(this.mockReporter);
        return loader.loadFromResource(resourceDir + "/" + ruleSetFilename);
    }

    protected Rule loadFirstRule(String ruleSetXml) {
        RuleSet rs = this.loadRuleSet(ruleSetXml);
        return (Rule)rs.getRules().iterator().next();
    }

    protected RuleSet loadRuleSet(String ruleSetXml) {
        return this.loadRuleSet("dummyRuleset.xml", ruleSetXml);
    }

    protected RuleSet loadRuleSet(String fileName, String ruleSetXml) {
        RuleSetLoader loader = new RuleSetLoader().withReporter(this.mockReporter);
        return loader.loadFromString(fileName, ruleSetXml);
    }

    protected RuleSet loadRuleSetWithDeprecationWarnings(String ruleSetXml) {
        PMDConfiguration config = new PMDConfiguration();
        config.setReporter(this.mockReporter);
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            RuleSet ruleSet = pmd.newRuleSetLoader().warnDeprecated(true).loadFromString("dummyRuleset.xml", ruleSetXml);
            return ruleSet;
        }
    }

    protected RuleSetLoadException assertCannotParse(String xmlContent) {
        return (RuleSetLoadException)Assertions.assertThrows(RuleSetLoadException.class, () -> this.loadFirstRule(xmlContent));
    }

    protected static @NonNull String rulesetXml(String ... contents) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<ruleset name=\"Custom ruleset\" xmlns=\"http://pmd.sourceforge.net/ruleset/2.0.0\"\n    xmlns:xsi=\"http:www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://pmd.sourceforge.net/ruleset/2.0.0 https://pmd.sourceforge.io/ruleset_2_0_0.xsd\">\n    <description>Ruleset which references a empty ruleset</description>\n\n" + RulesetFactoryTestBase.body(contents) + "</ruleset>\n";
    }

    protected static @NonNull String ruleRef(String ref) {
        return "<rule ref=\"" + ref + "\"/>\n";
    }

    protected static @NonNull String rule(Map<SchemaConstant, String> attrs, String ... body) {
        return "<rule " + RulesetFactoryTestBase.attrs(attrs) + ">\n" + RulesetFactoryTestBase.body(body) + "</rule>";
    }

    protected static @NonNull String dummyRule(Consumer<Map<SchemaConstant, String>> attributes, String ... body) {
        return RulesetFactoryTestBase.rule(CollectionUtil.buildMap(RulesetFactoryTestBase.dummyRuleDefAttrs(), attributes), body);
    }

    protected static @NonNull String dummyRule(String ... body) {
        return RulesetFactoryTestBase.dummyRule((Map<SchemaConstant, String> m) -> {}, body);
    }

    protected static Map<SchemaConstant, String> dummyRuleDefAttrs() {
        return CollectionUtil.buildMap(map -> {
            map.put(SchemaConstants.NAME, "MockRuleName");
            map.put(SchemaConstants.LANGUAGE, "dummy");
            map.put(SchemaConstants.CLASS, MockRuleWithNoProperties.class.getName());
            map.put(SchemaConstants.MESSAGE, "avoid the mock rule");
        });
    }

    private static @NonNull String attrs(Map<SchemaConstant, String> str) {
        return str.entrySet().stream().map(it -> ((SchemaConstant)it.getKey()).xmlName() + "=\"" + (String)it.getValue() + "\"").collect(Collectors.joining(" "));
    }

    protected static @NonNull String rulesetRef(String ref, String ... body) {
        return RulesetFactoryTestBase.ruleRef(ref, body);
    }

    protected static @NonNull String ruleRef(String ref, String ... body) {
        return "<rule ref=\"" + ref + "\">\n" + RulesetFactoryTestBase.body(body) + "</rule>\n";
    }

    protected static @NonNull String excludePattern(String pattern) {
        return RulesetFactoryTestBase.tagOneLine("exclude-pattern", pattern);
    }

    protected static @NonNull String excludeRule(String name) {
        return RulesetFactoryTestBase.emptyTag("exclude", CollectionUtil.buildMap(map -> map.put(SchemaConstants.NAME, name)));
    }

    protected static @NonNull String includePattern(String pattern) {
        return RulesetFactoryTestBase.tagOneLine("include-pattern", pattern);
    }

    protected static @NonNull String priority(String prio) {
        return RulesetFactoryTestBase.tagOneLine("priority", prio);
    }

    protected static @NonNull String description(String description) {
        return RulesetFactoryTestBase.tagOneLine("description", description);
    }

    protected static @NonNull String body(String ... lines) {
        return String.join((CharSequence)"\n", lines);
    }

    protected static @NonNull String properties(String ... body) {
        return RulesetFactoryTestBase.tag("properties", body);
    }

    protected static @NonNull String propertyWithValueAttr(String name, String valueAttr) {
        return "<property name='" + name + "' value='" + valueAttr + "'/>\n";
    }

    protected static @NonNull String propertyDefWithValueAttr(String name, String description, String type, String valueAttr) {
        return RulesetFactoryTestBase.propertyDefWithValueAttr(name, description, type, valueAttr, Collections.emptyMap());
    }

    protected static @NonNull String propertyDefWithValueAttr(String name, String description, String type, String valueAttr, Map<SchemaConstant, String> constraints) {
        return RulesetFactoryTestBase.emptyTag("property", CollectionUtil.buildMap(map -> {
            map.put(SchemaConstants.NAME, name);
            map.put(SchemaConstants.DESCRIPTION, description);
            map.put(SchemaConstants.PROPERTY_TYPE, type);
            map.put(SchemaConstants.PROPERTY_VALUE, valueAttr);
            map.putAll(constraints);
        }));
    }

    protected static @NonNull String tag(String tagName, String ... body) {
        return "<" + tagName + ">\n" + RulesetFactoryTestBase.body(body) + "</" + tagName + ">";
    }

    protected static @NonNull String emptyTag(String tagName, Map<SchemaConstant, String> attrs) {
        return "<" + tagName + " " + RulesetFactoryTestBase.attrs(attrs) + " />";
    }

    protected static @NonNull String tagOneLine(String tagName, String text) {
        return "<" + tagName + ">" + text + "</" + tagName + ">";
    }
}

