/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.lang.rule.RuleSetWriter;
import net.sourceforge.pmd.lang.rule.RulesetFactoryTestBase;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReference;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.xml.SchemaConstant;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RuleSetWriterTest
extends RulesetFactoryTestBase {
    private ByteArrayOutputStream out;
    private RuleSetWriter writer;

    RuleSetWriterTest() {
    }

    @BeforeEach
    void setupOutputStream() {
        this.out = new ByteArrayOutputStream();
        this.writer = new RuleSetWriter((OutputStream)this.out);
    }

    @AfterEach
    void cleanupStream() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Test
    void testWrite() throws Exception {
        RuleSet braces = new RuleSetLoader().loadFromResource("net/sourceforge/pmd/lang/rule/TestRuleset1.xml");
        RuleSet ruleSet = new RuleSet.RuleSetBuilder(new Random().nextLong()).withName("ruleset").withDescription("ruleset description").addRuleSetByReference(braces, true, new String[]{"MockRule2"}).build();
        this.writer.write(ruleSet);
        String written = this.out.toString(StandardCharsets.UTF_8.name());
        Assertions.assertTrue((boolean)written.contains("<exclude name=\"MockRule2\""));
    }

    @Test
    void testRuleReferenceOverriddenName() throws Exception {
        RuleSet rs = new RuleSetLoader().loadFromResource("rulesets/dummy/basic.xml");
        RuleReference ruleRef = new RuleReference(rs.getRuleByName("DummyBasicMockRule"), new RuleSetReference("rulesets/dummy/basic.xml"));
        ruleRef.setName("Foo");
        RuleSet ruleSet = RuleSet.forSingleRule((Rule)ruleRef);
        this.writer.write(ruleSet);
        String written = this.out.toString(StandardCharsets.UTF_8.name());
        Assertions.assertTrue((boolean)written.contains("ref=\"rulesets/dummy/basic.xml/DummyBasicMockRule\""));
    }

    @Test
    void testPropertyConstraintRange() throws Exception {
        RuleSet ruleSet = this.loadRuleSet("created-on-the-fly.xml", RuleSetWriterTest.rulesetXml(RuleSetWriterTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.CLASS, XPathRule.class.getName()), RuleSetWriterTest.properties(RuleSetWriterTest.propertyWithValueAttr("xpath", "//foo"), RuleSetWriterTest.propertyDefWithValueAttr("rangeProp", "the description", "Integer", "5", CollectionUtil.mapOf((Object)SchemaConstants.PROPERTY_MIN, (Object)"0", (Object)SchemaConstants.PROPERTY_MAX, (Object)"10"))))));
        this.writer.write(ruleSet);
        String written = this.out.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.containsString((String)"min=\"0\""));
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.containsString((String)"max=\"10\""));
    }

    @Test
    void testPropertyConstraintAbove() throws Exception {
        RuleSet ruleSet = this.loadRuleSet("created-on-the-fly.xml", RuleSetWriterTest.rulesetXml(RuleSetWriterTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.CLASS, XPathRule.class.getName()), RuleSetWriterTest.properties(RuleSetWriterTest.propertyWithValueAttr("xpath", "//foo"), RuleSetWriterTest.propertyDefWithValueAttr("rangeProp", "the description", "Integer", "5", CollectionUtil.mapOf((Object)SchemaConstants.PROPERTY_MIN, (Object)"0"))))));
        this.writer.write(ruleSet);
        String written = this.out.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.containsString((String)"min=\"0\""));
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"max=\"")));
    }

    @Test
    void testPropertyConstraintBelow() throws Exception {
        RuleSet ruleSet = this.loadRuleSet("created-on-the-fly.xml", RuleSetWriterTest.rulesetXml(RuleSetWriterTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.CLASS, XPathRule.class.getName()), RuleSetWriterTest.properties(RuleSetWriterTest.propertyWithValueAttr("xpath", "//foo"), RuleSetWriterTest.propertyDefWithValueAttr("rangeProp", "the description", "Integer", "5", CollectionUtil.mapOf((Object)SchemaConstants.PROPERTY_MAX, (Object)"10"))))));
        this.writer.write(ruleSet);
        String written = this.out.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"min=\"")));
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.containsString((String)"max=\"10\""));
    }

    @Test
    void overridingDefaultValueOfPropertyInReference() throws Exception {
        RuleSet ruleSet = this.loadRuleSet("created-on-the-fly.xml", RuleSetWriterTest.rulesetXml(RuleSetWriterTest.ruleRef("net/sourceforge/pmd/lang/rule/rulesetwriter-test.xml/SampleXPathRuleWithProperty", RuleSetWriterTest.properties(RuleSetWriterTest.propertyWithValueAttr("minimum", "42")))));
        this.writer.write(ruleSet);
        String written = this.out.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"min=\"")));
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"max=\"")));
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"type=\"")));
        MatcherAssert.assertThat((Object)written, (Matcher)Matchers.containsString((String)"value=\"42\""));
    }
}

