/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportTestUtil;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class RuleSetTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    RuleSetTest() {
    }

    @Test
    void testRuleSetRequiresName() {
        Assertions.assertThrows(NullPointerException.class, () -> new RuleSet.RuleSetBuilder(new Random().nextLong()).withName(null));
    }

    @Test
    void testRuleSetRequiresDescription() {
        Assertions.assertThrows(NullPointerException.class, () -> new RuleSet.RuleSetBuilder(new Random().nextLong()).withName("some name").withDescription(null));
    }

    @Test
    void testRuleSetRequiresName2() {
        Assertions.assertThrows(NullPointerException.class, () -> new RuleSet.RuleSetBuilder(new Random().nextLong()).build());
    }

    @Test
    void testAccessors() {
        RuleSet rs = new RuleSet.RuleSetBuilder(new Random().nextLong()).withFileName("baz").withName("foo").withDescription("bar").build();
        Assertions.assertEquals((Object)"baz", (Object)rs.getFileName(), (String)"file name mismatch");
        Assertions.assertEquals((Object)"foo", (Object)rs.getName(), (String)"name mismatch");
        Assertions.assertEquals((Object)"bar", (Object)rs.getDescription(), (String)"description mismatch");
    }

    @Test
    void testGetRuleByName() {
        MockRule mock = new MockRule("name", "desc", "msg", "rulesetname");
        RuleSet rs = RuleSet.forSingleRule((Rule)mock);
        Assertions.assertEquals((Object)((Object)mock), (Object)rs.getRuleByName("name"), (String)"unable to fetch rule by name");
    }

    @Test
    void testGetRuleByName2() {
        MockRule mock = new MockRule("name", "desc", "msg", "rulesetname");
        RuleSet rs = RuleSet.forSingleRule((Rule)mock);
        Assertions.assertNull((Object)rs.getRuleByName("FooRule"), (String)"the rule FooRule must not be found!");
    }

    @Test
    void testRuleList() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        RuleSet ruleset = RuleSet.forSingleRule((Rule)rule);
        Assertions.assertEquals((int)1, (int)ruleset.size(), (String)"Size of RuleSet isn't one.");
        Collection rules = ruleset.getRules();
        Iterator i = rules.iterator();
        Assertions.assertTrue((boolean)i.hasNext(), (String)"Empty Set");
        Assertions.assertEquals((int)1, (int)rules.size(), (String)"Returned set of wrong size.");
        Assertions.assertEquals((Object)((Object)rule), i.next(), (String)"Rule isn't in ruleset.");
    }

    private RuleSet.RuleSetBuilder createRuleSetBuilder(String name) {
        return new RuleSet.RuleSetBuilder(new Random().nextLong()).withName(name).withDescription("Description for " + name);
    }

    @Test
    void testAddRuleSet() {
        RuleSet set1 = this.createRuleSetBuilder("ruleset1").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        RuleSet set2 = this.createRuleSetBuilder("ruleset2").addRule((Rule)new MockRule("name2", "desc", "msg", "rulesetname")).addRuleSet(set1).build();
        Assertions.assertEquals((int)2, (int)set2.size(), (String)"ruleset size wrong");
    }

    @Test
    void testAddRuleSetByReferenceBad() {
        RuleSet set1 = this.createRuleSetBuilder("ruleset1").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        Assertions.assertThrows(RuntimeException.class, () -> this.createRuleSetBuilder("ruleset2").addRule((Rule)new MockRule("name2", "desc", "msg", "rulesetname")).addRuleSetByReference(set1, false).build());
    }

    @Test
    void testAddRuleSetByReferenceAllRule() {
        RuleSet set2 = this.createRuleSetBuilder("ruleset2").withFileName("foo").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).addRule((Rule)new MockRule("name2", "desc", "msg", "rulesetname")).build();
        RuleSet set1 = this.createRuleSetBuilder("ruleset1").addRuleSetByReference(set2, true).build();
        Assertions.assertEquals((int)2, (int)set1.getRules().size(), (String)"wrong rule size");
        for (Rule rule : set1.getRules()) {
            Assertions.assertTrue((boolean)(rule instanceof RuleReference), (String)"not a rule reference");
            RuleReference ruleReference = (RuleReference)rule;
            Assertions.assertEquals((Object)"foo", (Object)ruleReference.getRuleSetReference().getRuleSetFileName(), (String)"wrong ruleset file name");
            Assertions.assertTrue((boolean)ruleReference.getRuleSetReference().isAllRules(), (String)"not all rule reference");
        }
    }

    @Test
    void testAddRuleSetByReferenceSingleRule() {
        RuleSet set2 = this.createRuleSetBuilder("ruleset2").withFileName("foo").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).addRule((Rule)new MockRule("name2", "desc", "msg", "rulesetname")).build();
        RuleSet set1 = this.createRuleSetBuilder("ruleset1").addRuleSetByReference(set2, false).build();
        Assertions.assertEquals((int)2, (int)set1.getRules().size(), (String)"wrong rule size");
        for (Rule rule : set1.getRules()) {
            Assertions.assertTrue((boolean)(rule instanceof RuleReference), (String)"not a rule reference");
            RuleReference ruleReference = (RuleReference)rule;
            Assertions.assertEquals((Object)"foo", (Object)ruleReference.getRuleSetReference().getRuleSetFileName(), (String)"wrong ruleset file name");
            Assertions.assertFalse((boolean)ruleReference.getRuleSetReference().isAllRules(), (String)"should not be all rule reference");
        }
    }

    @Test
    void testApply0Rules() throws Exception {
        RuleSet ruleset = this.createRuleSetBuilder("ruleset").build();
        this.verifyRuleSet(ruleset, new HashSet<RuleViolation>());
    }

    @Test
    void testEquals1() {
        RuleSet s = this.createRuleSetBuilder("ruleset").build();
        Assertions.assertFalse((boolean)s.equals(null), (String)"A ruleset cannot be equals to null");
    }

    @Test
    void testEquals2() {
        RuleSet s = this.createRuleSetBuilder("ruleset").build();
        Assertions.assertTrue((boolean)s.equals((Object)s), (String)"A rulset must be equals to itself");
    }

    @Test
    void testEquals3() {
        RuleSet s = new RuleSet.RuleSetBuilder(new Random().nextLong()).withName("basic rules").withDescription("desc").build();
        Assertions.assertFalse((boolean)s.equals((Object)"basic rules"), (String)"A ruleset cannot be equals to another kind of object");
    }

    @Test
    void testEquals4() {
        RuleSet s1 = this.createRuleSetBuilder("my ruleset").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        RuleSet s2 = this.createRuleSetBuilder("my ruleset").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        Assertions.assertEquals((Object)s1, (Object)s2, (String)"2 rulesets with same name and rules must be equals");
        Assertions.assertEquals((int)s1.hashCode(), (int)s2.hashCode(), (String)"Equals rulesets must have the same hashcode");
    }

    @Test
    void testEquals5() {
        RuleSet s1 = this.createRuleSetBuilder("my ruleset").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        RuleSet s2 = this.createRuleSetBuilder("my other ruleset").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        Assertions.assertFalse((boolean)s1.equals((Object)s2), (String)"2 rulesets with different name but same rules must not be equals");
    }

    @Test
    void testEquals6() {
        RuleSet s1 = this.createRuleSetBuilder("my ruleset").addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname")).build();
        RuleSet s2 = this.createRuleSetBuilder("my ruleset").addRule((Rule)new MockRule("other rule", "desc", "msg", "rulesetname")).build();
        Assertions.assertFalse((boolean)s1.equals((Object)s2), (String)"2 rulesets with same name but different rules must not be equals");
    }

    @Test
    void testLanguageApplies() {
        MockRule rule = new MockRule();
        Assertions.assertFalse((boolean)RuleSet.applies((Rule)rule, (LanguageVersion)PmdCoreTestUtils.dummyLanguage2().getDefaultVersion()), (String)"Different languages should not apply");
        Assertions.assertTrue((boolean)RuleSet.applies((Rule)rule, (LanguageVersion)PmdCoreTestUtils.dummyLanguage().getVersion("1.5")), (String)"Same language with no min/max should apply");
        rule.setMinimumLanguageVersion(PmdCoreTestUtils.dummyLanguage().getVersion("1.5"));
        Assertions.assertTrue((boolean)RuleSet.applies((Rule)rule, (LanguageVersion)PmdCoreTestUtils.dummyLanguage().getVersion("1.5")), (String)"Same language with valid min only should apply");
        rule.setMaximumLanguageVersion(PmdCoreTestUtils.dummyLanguage().getVersion("1.6"));
        Assertions.assertTrue((boolean)RuleSet.applies((Rule)rule, (LanguageVersion)PmdCoreTestUtils.dummyLanguage().getVersion("1.5")), (String)"Same language with valid min and max should apply");
        Assertions.assertFalse((boolean)RuleSet.applies((Rule)rule, (LanguageVersion)PmdCoreTestUtils.dummyLanguage().getVersion("1.4")), (String)"Same language with outside range of min/max should not apply");
        Assertions.assertFalse((boolean)RuleSet.applies((Rule)rule, (LanguageVersion)PmdCoreTestUtils.dummyLanguage().getVersion("1.7")), (String)"Same language with outside range of min/max should not apply");
    }

    @Test
    void testAddExcludePattern() {
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset1").withFileExclusions(Pattern.compile(".*"), new Pattern[0]).build();
        Assertions.assertNotNull((Object)ruleSet.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)1, (int)ruleSet.getFileExclusions().size(), (String)"Invalid number of patterns");
    }

    @Test
    void testExcludePatternAreOrdered() {
        RuleSet ruleSet2 = this.createRuleSetBuilder("ruleset2").withFileExclusions(Pattern.compile(".*"), new Pattern[0]).withFileExclusions(Pattern.compile(".*ha"), new Pattern[0]).build();
        Assertions.assertEquals(Arrays.asList(".*", ".*ha"), this.toStrings(ruleSet2.getFileExclusions()), (String)"Exclude pattern");
    }

    @Test
    void testIncludePatternsAreOrdered() {
        RuleSet ruleSet2 = this.createRuleSetBuilder("ruleset2").withFileInclusions(Pattern.compile(".*"), new Pattern[0]).withFileInclusions(Arrays.asList(Pattern.compile(".*ha"), Pattern.compile(".*hb"))).build();
        Assertions.assertEquals(Arrays.asList(".*", ".*ha", ".*hb"), this.toStrings(ruleSet2.getFileInclusions()), (String)"Exclude pattern");
    }

    private List<String> toStrings(List<Pattern> strings) {
        return strings.stream().map(Pattern::pattern).collect(Collectors.toList());
    }

    @Test
    void testAddExcludePatterns() {
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset1").withFileExclusions(Pattern.compile(".*"), new Pattern[0]).build();
        Assertions.assertNotNull((Object)ruleSet.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)1, (int)ruleSet.getFileExclusions().size(), (String)"Invalid number of patterns");
        RuleSet ruleSet2 = this.createRuleSetBuilder("ruleset2").withFileExclusions((Collection)ruleSet.getFileExclusions()).build();
        Assertions.assertNotNull((Object)ruleSet2.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)1, (int)ruleSet2.getFileExclusions().size(), (String)"Invalid number of patterns");
    }

    @Test
    void testSetExcludePatterns() {
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
        excludePatterns.add(Pattern.compile("ah*"));
        excludePatterns.add(Pattern.compile(".*"));
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset").replaceFileExclusions(excludePatterns).build();
        Assertions.assertNotNull((Object)ruleSet.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)2, (int)ruleSet.getFileExclusions().size(), (String)"Invalid number of exclude patterns");
        Assertions.assertEquals((Object)"ah*", (Object)((Pattern)ruleSet.getFileExclusions().get(0)).pattern(), (String)"Exclude pattern");
        Assertions.assertEquals((Object)".*", (Object)((Pattern)ruleSet.getFileExclusions().get(1)).pattern(), (String)"Exclude pattern");
        Assertions.assertNotNull((Object)ruleSet.getFileInclusions(), (String)"Include patterns");
        Assertions.assertEquals((int)0, (int)ruleSet.getFileInclusions().size(), (String)"Invalid number of include patterns");
    }

    @Test
    void testAddIncludePattern() {
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset").withFileInclusions(Pattern.compile(".*"), new Pattern[0]).build();
        Assertions.assertNotNull((Object)ruleSet.getFileInclusions(), (String)"Include patterns");
        Assertions.assertEquals((int)1, (int)ruleSet.getFileInclusions().size(), (String)"Invalid number of patterns");
        Assertions.assertEquals((Object)".*", (Object)((Pattern)ruleSet.getFileInclusions().get(0)).pattern(), (String)"Include pattern");
        Assertions.assertNotNull((Object)ruleSet.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)0, (int)ruleSet.getFileExclusions().size(), (String)"Invalid number of exclude patterns");
    }

    @Test
    void testAddIncludePatterns() {
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset1").withFileInclusions(Pattern.compile("ah*"), new Pattern[]{Pattern.compile(".*")}).build();
        RuleSet ruleSet2 = this.createRuleSetBuilder("ruleset1").withFileInclusions((Collection)ruleSet.getFileInclusions()).build();
        Assertions.assertNotNull((Object)ruleSet2.getFileInclusions(), (String)"Include patterns");
        Assertions.assertEquals((int)2, (int)ruleSet2.getFileInclusions().size(), (String)"Invalid number of patterns");
        Assertions.assertEquals((Object)"ah*", (Object)((Pattern)ruleSet2.getFileInclusions().get(0)).pattern(), (String)"Include pattern");
        Assertions.assertEquals((Object)".*", (Object)((Pattern)ruleSet2.getFileInclusions().get(1)).pattern(), (String)"Include pattern");
        Assertions.assertNotNull((Object)ruleSet.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)0, (int)ruleSet.getFileExclusions().size(), (String)"Invalid number of exclude patterns");
    }

    @Test
    void testSetIncludePatterns() {
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        includePatterns.add(Pattern.compile("ah*"));
        includePatterns.add(Pattern.compile(".*"));
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset").replaceFileInclusions(includePatterns).build();
        Assertions.assertEquals(includePatterns, (Object)ruleSet.getFileInclusions(), (String)"Include patterns");
        Assertions.assertNotNull((Object)ruleSet.getFileInclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)0, (int)ruleSet.getFileExclusions().size(), (String)"Invalid number of exclude patterns");
    }

    @Test
    void testIncludeExcludeApplies() {
        FileId fileId = TextFile.forPath((Path)Paths.get("C:\\myworkspace\\project\\some\\random\\package\\RandomClass.java", new String[0]), (Charset)Charset.defaultCharset(), (LanguageVersion)PmdCoreTestUtils.dummyVersion()).getFileId();
        RuleSet ruleSet = this.createRuleSetBuilder("ruleset").build();
        Assertions.assertTrue((boolean)ruleSet.applies(fileId), (String)"No patterns");
        ruleSet = this.createRuleSetBuilder("ruleset").withFileExclusions(Pattern.compile("nomatch"), new Pattern[0]).build();
        Assertions.assertTrue((boolean)ruleSet.applies(fileId), (String)"Non-matching exclude");
        ruleSet = this.createRuleSetBuilder("ruleset").withFileExclusions(Pattern.compile("nomatch"), new Pattern[]{Pattern.compile(".*/package/.*")}).build();
        Assertions.assertFalse((boolean)ruleSet.applies(fileId), (String)"Matching exclude");
        ruleSet = this.createRuleSetBuilder("ruleset").withFileExclusions(Pattern.compile("nomatch"), new Pattern[0]).withFileExclusions(Pattern.compile(".*/package/.*"), new Pattern[0]).withFileInclusions(Pattern.compile(".*/randomX/.*"), new Pattern[0]).build();
        Assertions.assertFalse((boolean)ruleSet.applies(fileId), (String)"Non-matching include");
        ruleSet = this.createRuleSetBuilder("ruleset").withFileExclusions(Pattern.compile("nomatch"), new Pattern[0]).withFileExclusions(Pattern.compile(".*/package/.*"), new Pattern[0]).withFileInclusions(Pattern.compile(".*/randomX/.*"), new Pattern[0]).withFileInclusions(Pattern.compile(".*/random/.*"), new Pattern[0]).build();
        Assertions.assertTrue((boolean)ruleSet.applies(fileId), (String)"Matching include");
    }

    @Test
    void testIncludeExcludeMultipleRuleSetWithRuleChainApplies() throws Exception {
        FooRule rule = new FooRule();
        rule.setName("FooRule1");
        rule.setLanguage((Language)PmdCoreTestUtils.dummyLanguage());
        RuleSet ruleSet1 = this.createRuleSetBuilder("RuleSet1").addRule((Rule)rule).build();
        RuleSet ruleSet2 = this.createRuleSetBuilder("RuleSet2").addRule((Rule)rule).build();
        RuleSets ruleSets = new RuleSets((Collection)CollectionUtil.listOf((Object)ruleSet1, (Object[])new RuleSet[]{ruleSet2}));
        Report report = Report.buildReport(ctx1 -> ruleSets.apply(this.makeCompilationUnits(), ctx1));
        Assertions.assertEquals((int)2, (int)report.getViolations().size(), (String)"Violations");
        ruleSet1 = this.createRuleSetBuilder("RuleSet1").withFileExclusions(Pattern.compile(".*/package/.*"), new Pattern[0]).addRule((Rule)rule).build();
        RuleSets ruleSets2 = new RuleSets((Collection)CollectionUtil.listOf((Object)ruleSet1, (Object[])new RuleSet[]{ruleSet2}));
        report = Report.buildReport(ctx -> ruleSets2.apply(this.makeCompilationUnits("C:\\package\\RandomClass.java"), ctx));
        Assertions.assertEquals((int)1, (int)report.getViolations().size(), (String)"Violations");
    }

    @Test
    void copyConstructorDeepCopies() {
        FooRule rule = new FooRule();
        rule.setName("FooRule1");
        RuleSet ruleSet1 = this.createRuleSetBuilder("RuleSet1").addRule((Rule)rule).build();
        RuleSet ruleSet2 = new RuleSet(ruleSet1);
        Assertions.assertEquals((Object)ruleSet1, (Object)ruleSet2);
        Assertions.assertNotSame((Object)ruleSet1, (Object)ruleSet2);
        Assertions.assertEquals((Object)((Object)rule), (Object)ruleSet2.getRuleByName("FooRule1"));
        Assertions.assertNotSame((Object)((Object)rule), (Object)ruleSet2.getRuleByName("FooRule1"));
    }

    private void verifyRuleSet(RuleSet ruleset, Set<RuleViolation> expected) throws Exception {
        Report report = ReportTestUtil.getReportForRuleSetApply(ruleset, this.makeCompilationUnits());
        Assertions.assertEquals((int)expected.size(), (int)report.getViolations().size(), (String)"Invalid number of Violations Reported");
        for (RuleViolation violation : report.getViolations()) {
            Assertions.assertTrue((boolean)expected.contains(violation), (String)("Unexpected Violation Returned: " + violation));
        }
        for (RuleViolation violation : expected) {
            Assertions.assertTrue((boolean)report.getViolations().contains(violation), (String)("Expected Violation not Returned: " + violation));
        }
    }

    private RootNode makeCompilationUnits() {
        return this.makeCompilationUnits("sampleFile.dummy");
    }

    private RootNode makeCompilationUnits(String filename) {
        DummyNode.DummyRootNode node = this.helper.parse("dummyCode", filename);
        node.setImage("Foo");
        return node;
    }

    @Test
    void ruleExceptionShouldBeReported() throws Exception {
        RuleSet ruleset = this.createRuleSetBuilder("ruleExceptionShouldBeReported").addRule((Rule)new MockRule(){

            @Override
            public void apply(Node nodes, RuleContext ctx) {
                throw new IllegalStateException("Test exception while applying rule");
            }
        }).build();
        Report report = ReportTestUtil.getReportForRuleSetApply(ruleset, this.makeCompilationUnits());
        List errors = report.getProcessingErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        Report.ProcessingError error = (Report.ProcessingError)errors.get(0);
        MatcherAssert.assertThat((Object)error.getMsg(), (Matcher)CoreMatchers.containsString((String)"java.lang.IllegalStateException: Test exception while applying rule\n"));
        MatcherAssert.assertThat((Object)error.getMsg(), (Matcher)CoreMatchers.containsString((String)"Rule applied on node=dummyRootNode[@Image=Foo]"));
        MatcherAssert.assertThat((Object)error.getError().getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
    }

    @Test
    void ruleExceptionShouldNotStopProcessingFile() throws Exception {
        RuleSet ruleset = this.createRuleSetBuilder("ruleExceptionShouldBeReported").addRule((Rule)new MockRule(){

            @Override
            public void apply(Node target, RuleContext ctx) {
                throw new IllegalStateException("Test exception while applying rule");
            }
        }).addRule((Rule)new MockRule(){

            @Override
            public void apply(Node target, RuleContext ctx) {
                ctx.addViolationWithMessage(target, "Test violation of the second rule in the ruleset");
            }
        }).build();
        Report report = ReportTestUtil.getReportForRuleSetApply(ruleset, this.makeCompilationUnits("samplefile.dummy"));
        List errors = report.getProcessingErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        Report.ProcessingError error = (Report.ProcessingError)errors.get(0);
        MatcherAssert.assertThat((Object)error.getMsg(), (Matcher)CoreMatchers.containsString((String)"java.lang.IllegalStateException: Test exception while applying rule\n"));
        MatcherAssert.assertThat((Object)error.getMsg(), (Matcher)CoreMatchers.containsString((String)"Rule applied on node=dummyRootNode[@Image=Foo]"));
        MatcherAssert.assertThat((Object)error.getError().getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)error.getFileId().getFileName(), (Matcher)CoreMatchers.equalTo((Object)"samplefile.dummy"));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void ruleExceptionShouldNotStopProcessingFileWithRuleChain() throws Exception {
        RuleSet ruleset = this.createRuleSetBuilder("ruleExceptionShouldBeReported").addRule((Rule)new MockRule(){

            protected @NonNull RuleTargetSelector buildTargetSelector() {
                return RuleTargetSelector.forXPathNames((Collection)CollectionUtil.setOf((Object)"dummyRootNode", (Object[])new String[0]));
            }

            @Override
            public void apply(Node target, RuleContext ctx) {
                throw new UnsupportedOperationException("Test exception while applying rule");
            }
        }).addRule((Rule)new MockRule(){

            protected @NonNull RuleTargetSelector buildTargetSelector() {
                return RuleTargetSelector.forXPathNames((Collection)CollectionUtil.setOf((Object)"dummyRootNode", (Object[])new String[0]));
            }

            @Override
            public void apply(Node target, RuleContext ctx) {
                ctx.addViolationWithMessage(target, "Test violation of the second rule in the ruleset");
            }
        }).build();
        Report report = ReportTestUtil.getReportForRuleSetApply(ruleset, this.makeCompilationUnits());
        List errors = report.getProcessingErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        Report.ProcessingError error = (Report.ProcessingError)errors.get(0);
        MatcherAssert.assertThat((Object)error.getMsg(), (Matcher)CoreMatchers.containsString((String)"java.lang.UnsupportedOperationException: Test exception while applying rule\n"));
        MatcherAssert.assertThat((Object)error.getMsg(), (Matcher)CoreMatchers.containsString((String)"Rule applied on node=dummyRootNode[@Image=Foo]"));
        MatcherAssert.assertThat((Object)error.getError().getCause(), (Matcher)CoreMatchers.instanceOf(UnsupportedOperationException.class));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }
}

