/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.Set;
import net.sourceforge.pmd.lang.DummyLanguageDialectModule;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SimpleDialectLanguageModuleBaseTest {
    SimpleDialectLanguageModuleBaseTest() {
    }

    @Test
    void baseLanguageXPathFunctionAvailable() throws Exception {
        DummyLanguageModule lang = DummyLanguageModule.getInstance();
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        try (LanguageProcessor baseProcessor = lang.createProcessor(lang.newPropertyBundle());
             LanguageProcessor dialectProcessor = dialect.createProcessor(dialect.newPropertyBundle());){
            Set dialectFunctions = dialectProcessor.services().getXPathHandler().getRegisteredExtensionFunctions();
            for (XPathFunctionDefinition fn : baseProcessor.services().getXPathHandler().getRegisteredExtensionFunctions()) {
                Assertions.assertTrue((boolean)dialectFunctions.contains(fn), (String)("The function " + fn.getQName() + " is not available in the dialect."));
            }
        }
    }

    @Test
    void dialectSpecificXPathFunctionAvailable() throws Exception {
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        try (LanguageProcessor dialectProcessor = dialect.createProcessor(dialect.newPropertyBundle());){
            Set dialectFunctions = dialectProcessor.services().getXPathHandler().getRegisteredExtensionFunctions();
            XPathFunctionDefinition dummyDialectFunction = DummyLanguageDialectModule.dummyDialectFunction();
            Assertions.assertTrue((boolean)dialectFunctions.contains(dummyDialectFunction), (String)("The function " + dummyDialectFunction.getQName() + " is not available in the dialect."));
        }
    }

    @Test
    void baseLanguagePropertiesAreAvailable() {
        DummyLanguageModule lang = DummyLanguageModule.getInstance();
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        LanguagePropertyBundle languagePropertyBundle = lang.newPropertyBundle();
        LanguagePropertyBundle dialectPropertyBundle = dialect.newPropertyBundle();
        for (PropertyDescriptor pd : languagePropertyBundle.getPropertyDescriptors()) {
            Assertions.assertTrue((boolean)dialectPropertyBundle.hasDescriptor(pd), (String)("The property " + pd.name() + " is not available in the dialect."));
        }
    }

    @Test
    void dialectSpecificPropertiesAreAvailable() {
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        LanguagePropertyBundle dialectPropertyBundle = dialect.newPropertyBundle();
        Assertions.assertTrue((boolean)dialectPropertyBundle.hasDescriptor(DummyLanguageDialectModule.DUMMY_DIALECT_PROP), (String)("The property " + DummyLanguageDialectModule.DUMMY_DIALECT_PROP.name() + " is not available in the dialect."));
    }

    @Test
    void baseLanguageMetricsAreAvailable() throws Exception {
        DummyLanguageModule lang = DummyLanguageModule.getInstance();
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        try (LanguageProcessor baseProcessor = lang.createProcessor(lang.newPropertyBundle());
             LanguageProcessor dialectProcessor = dialect.createProcessor(dialect.newPropertyBundle());){
            for (Metric metric : baseProcessor.services().getLanguageMetricsProvider().getMetrics()) {
                Assertions.assertNotNull((Object)dialectProcessor.services().getLanguageMetricsProvider().getMetricWithName(metric.displayName()), (String)("The metric " + metric.displayName() + " is not available in the dialect."));
            }
        }
    }

    @Test
    void dialectSpecificMetricsAreAvailable() throws Exception {
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        try (LanguageProcessor dialectProcessor = dialect.createProcessor(dialect.newPropertyBundle());){
            Assertions.assertTrue((boolean)dialectProcessor.services().getLanguageMetricsProvider().getMetrics().contains(DummyLanguageDialectModule.DUMMY_DIALECT_METRIC), (String)("The metric " + DummyLanguageDialectModule.DUMMY_DIALECT_METRIC.displayName() + "is not available in the dialect"));
        }
    }
}

