/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.impl.SimpleLanguageModuleBase;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.ContextedAssertionError;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.event.Level;

class PmdRunnableTest {
    public static final String TEST_MESSAGE_SEMANTIC_ERROR = "An error occurred!";
    private static final String PARSER_REPORTS_SEMANTIC_ERROR = "1.9-semantic_error";
    private static final String THROWS_SEMANTIC_ERROR = "1.9-throws_semantic_error";
    private static final String THROWS_ASSERTION_ERROR = "1.9-throws";
    private PMDConfiguration configuration;
    private PmdReporter reporter;
    private Rule rule;

    PmdRunnableTest() {
    }

    @BeforeEach
    void prepare() {
        this.rule = (Rule)Mockito.spy((Object)((Object)new RuleThatThrows()));
        this.configuration = new PMDConfiguration(LanguageRegistry.singleton((Language)ThrowingLanguageModule.INSTANCE));
        this.reporter = (PmdReporter)Mockito.mock(PmdReporter.class);
        this.configuration.setReporter(this.reporter);
        this.configuration.setThreads(0);
    }

    private Report process(LanguageVersion lv) {
        this.configuration.setForceLanguageVersion(lv);
        this.configuration.setIgnoreIncrementalAnalysis(true);
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)this.configuration);){
            pmd.files().addSourceFile(FileId.fromPathLikeString((String)"test.dummy"), "foo");
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)this.rule));
            Report report = pmd.performAnalysisAndCollectReport();
            return report;
        }
    }

    @Test
    void inErrorRecoveryModeErrorsShouldBeLoggedByParser() throws Exception {
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty("pmd.error_recovery", "");
            Report report = this.process(PmdRunnableTest.versionWithParserThatThrowsAssertionError());
            Assertions.assertEquals((int)1, (int)report.getProcessingErrors().size());
        });
    }

    @Test
    void inErrorRecoveryModeErrorsShouldBeLoggedByRule() throws Exception {
        SystemLambda.restoreSystemProperties(() -> {
            System.setProperty("pmd.error_recovery", "");
            Report report = this.process(ThrowingLanguageModule.INSTANCE.getDefaultVersion());
            List errors = report.getProcessingErrors();
            MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((Report.ProcessingError)errors.get(0)).getError(), (Matcher)CoreMatchers.instanceOf(ContextedAssertionError.class));
        });
    }

    @Test
    void withoutErrorRecoveryModeProcessingShouldBeAbortedByParser() throws Exception {
        SystemLambda.restoreSystemProperties(() -> {
            System.clearProperty("pmd.error_recovery");
            Assertions.assertThrows(AssertionError.class, () -> this.process(PmdRunnableTest.versionWithParserThatThrowsAssertionError()));
        });
    }

    @Test
    void withoutErrorRecoveryModeProcessingShouldBeAbortedByRule() throws Exception {
        SystemLambda.restoreSystemProperties(() -> {
            System.clearProperty("pmd.error_recovery");
            Assertions.assertThrows(AssertionError.class, () -> this.process(ThrowingLanguageModule.INSTANCE.getDefaultVersion()));
        });
    }

    @Test
    void semanticErrorShouldAbortTheRun() {
        Report report = this.process(PmdRunnableTest.versionWithParserThatReportsSemanticError());
        ((PmdReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).log((Level)Mockito.eq((Object)Level.ERROR), (String)Mockito.eq((Object)"at test.dummy:1:1: An error occurred!"), new Object[0]);
        ((Rule)Mockito.verify((Object)this.rule, (VerificationMode)Mockito.never())).apply((Node)Mockito.any(), (RuleContext)Mockito.any());
        Assertions.assertEquals((int)1, (int)report.getProcessingErrors().size());
    }

    @Test
    void semanticErrorThrownShouldAbortTheRun() {
        Report report = this.process(PmdRunnableTest.getVersionWithParserThatThrowsSemanticError());
        ((PmdReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).log((Level)Mockito.eq((Object)Level.ERROR), Mockito.contains((String)TEST_MESSAGE_SEMANTIC_ERROR), new Object[0]);
        ((Rule)Mockito.verify((Object)this.rule, (VerificationMode)Mockito.never())).apply((Node)Mockito.any(), (RuleContext)Mockito.any());
        Assertions.assertEquals((int)1, (int)report.getProcessingErrors().size());
    }

    private static LanguageVersion versionWithParserThatThrowsAssertionError() {
        return ThrowingLanguageModule.INSTANCE.getVersion(THROWS_ASSERTION_ERROR);
    }

    private static LanguageVersion getVersionWithParserThatThrowsSemanticError() {
        return ThrowingLanguageModule.INSTANCE.getVersion(THROWS_SEMANTIC_ERROR);
    }

    private static LanguageVersion versionWithParserThatReportsSemanticError() {
        return ThrowingLanguageModule.INSTANCE.getVersion(PARSER_REPORTS_SEMANTIC_ERROR);
    }

    private static class RuleThatThrows
    extends AbstractRule {
        RuleThatThrows() {
            this.setLanguage((Language)ThrowingLanguageModule.INSTANCE);
        }

        public void apply(Node target, RuleContext ctx) {
            throw new AssertionError((Object)"test");
        }
    }

    private static class ThrowingLanguageModule
    extends SimpleLanguageModuleBase {
        static final ThrowingLanguageModule INSTANCE = new ThrowingLanguageModule();

        ThrowingLanguageModule() {
            super(LanguageModuleBase.LanguageMetadata.withId((String)"foo").name("Foo").extensions("foo", new String[0]).addVersion(PmdRunnableTest.THROWS_ASSERTION_ERROR, new String[0]).addVersion(PmdRunnableTest.THROWS_SEMANTIC_ERROR, new String[0]).addVersion(PmdRunnableTest.PARSER_REPORTS_SEMANTIC_ERROR, new String[0]).addDefaultVersion("defalt", new String[0]), ThrowingLanguageModule::makeParser);
        }

        private static Parser makeParser() {
            return task -> {
                switch (task.getLanguageVersion().getVersion()) {
                    case "1.9-throws": {
                        throw new AssertionError((Object)"test error while parsing");
                    }
                    case "1.9-semantic_error": {
                        DummyNode.DummyRootNode root = DummyLanguageModule.readLispNode(task);
                        task.getReporter().error((Node)root, PmdRunnableTest.TEST_MESSAGE_SEMANTIC_ERROR, new Object[0]);
                        return root;
                    }
                    case "1.9-throws_semantic_error": {
                        DummyNode.DummyRootNode root = DummyLanguageModule.readLispNode(task);
                        throw task.getReporter().error((Node)root, PmdRunnableTest.TEST_MESSAGE_SEMANTIC_ERROR, new Object[0]);
                    }
                }
                return DummyLanguageModule.readLispNode(task);
            };
        }
    }
}

