/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.InternalApiBridge;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessor;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.event.Level;

abstract class AbstractPMDProcessorTest {
    protected SimpleReportListener reportListener;
    protected PmdReporter reporter;

    AbstractPMDProcessorTest() {
    }

    protected abstract int getThreads();

    protected abstract Class<? extends AbstractPMDProcessor> getExpectedImplementation();

    @Test
    void shouldUseCorrectProcessorImpl() {
        try (AbstractPMDProcessor processor = AbstractPMDProcessor.newFileProcessor((LanguageProcessor.AnalysisTask)this.createTask(this.getThreads()));){
            Assertions.assertSame(this.getExpectedImplementation(), processor.getClass());
        }
    }

    private LanguageProcessor.AnalysisTask createTask(int threads) {
        return InternalApiBridge.createAnalysisTask(null, null, null, (int)threads, null, (PmdReporter)((PmdReporter)Mockito.mock(PmdReporter.class)), null);
    }

    @Test
    void exceptionsShouldBeLogged() {
        try (PmdAnalysis pmd = this.createPmdAnalysis();){
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)new RuleThatThrowsException()));
            pmd.performAnalysis();
        }
        Assertions.assertEquals((int)2, (int)this.reportListener.files.get());
        Assertions.assertEquals((int)2, (int)this.reportListener.errors.get());
        if (this.getThreads() == 0) {
            ((PmdReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)2))).log(Level.DEBUG, "Using main thread for analysis", new Object[0]);
        } else {
            ((PmdReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)2))).log(Level.DEBUG, "Using {0} threads for analysis", new Object[]{this.getThreads()});
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.reporter});
    }

    protected PmdAnalysis createPmdAnalysis() {
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setThreads(this.getThreads());
        configuration.setIgnoreIncrementalAnalysis(true);
        this.reporter = (PmdReporter)Mockito.mock(PmdReporter.class);
        configuration.setReporter(this.reporter);
        PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);
        LanguageVersion lv = DummyLanguageModule.getInstance().getDefaultVersion();
        pmd.files().addFile(TextFile.forCharSeq((CharSequence)"abc", (FileId)FileId.fromPathLikeString((String)"file1-violation.dummy"), (LanguageVersion)lv));
        pmd.files().addFile(TextFile.forCharSeq((CharSequence)"DEF", (FileId)FileId.fromPathLikeString((String)"file2-foo.dummy"), (LanguageVersion)lv));
        this.reportListener = new SimpleReportListener();
        GlobalAnalysisListener listener = GlobalAnalysisListener.tee((Collection)CollectionUtil.listOf((Object)new Report.GlobalReportBuilderListener(), (Object[])new GlobalAnalysisListener[]{this.reportListener}));
        pmd.addListener(listener);
        return pmd;
    }

    protected static class SimpleReportListener
    implements GlobalAnalysisListener {
        public AtomicInteger violations = new AtomicInteger(0);
        public AtomicInteger files = new AtomicInteger(0);
        public AtomicInteger errors = new AtomicInteger(0);

        protected SimpleReportListener() {
        }

        public FileAnalysisListener startFileAnalysis(TextFile file) {
            this.files.incrementAndGet();
            return new FileAnalysisListener(){

                public void onRuleViolation(RuleViolation violation) {
                    violations.incrementAndGet();
                }

                public void onError(Report.ProcessingError error) {
                    errors.incrementAndGet();
                }
            };
        }

        public void close() throws Exception {
        }
    }

    protected static class RuleThatThrowsError
    extends AbstractRule {
        RuleThatThrowsError() {
            this.setLanguage(DummyLanguageModule.getInstance().getDefaultVersion().getLanguage());
        }

        public void apply(Node target, RuleContext ctx) {
            throw new Error("test error");
        }
    }

    protected static class RuleThatThrowsException
    extends AbstractRule {
        RuleThatThrowsException() {
            this.setLanguage(DummyLanguageModule.getInstance().getDefaultVersion().getLanguage());
        }

        public void apply(Node target, RuleContext ctx) {
            throw new RuntimeException("test exception");
        }
    }
}

