/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.document.TextRegion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TextRegionTest {
    TextRegionTest() {
    }

    @Test
    void testIsEmpty() {
        TextRegion r = TextRegion.fromOffsetLength((int)0, (int)0);
        Assertions.assertTrue((boolean)r.isEmpty());
    }

    @Test
    void testEmptyContains() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)0, (int)0);
        Assertions.assertFalse((boolean)r1.contains(0));
    }

    @Test
    void testContains() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)1, (int)2);
        Assertions.assertFalse((boolean)r1.contains(0));
        Assertions.assertTrue((boolean)r1.contains(1));
        Assertions.assertTrue((boolean)r1.contains(2));
        Assertions.assertFalse((boolean)r1.contains(3));
    }

    @Test
    void testIntersectZeroLen() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)0, (int)0);
        TextRegion r2 = TextRegion.fromOffsetLength((int)0, (int)5);
        TextRegion inter = this.doIntersect(r1, r2);
        Assertions.assertEquals((Object)r1, (Object)inter);
    }

    @Test
    void testIntersectZeroLen2() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)5, (int)0);
        TextRegion r2 = TextRegion.fromOffsetLength((int)0, (int)5);
        TextRegion inter = this.doIntersect(r1, r2);
        Assertions.assertEquals((Object)r1, (Object)inter);
    }

    @Test
    void testIntersectZeroLen3() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)3, (int)3);
        TextRegion r2 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion inter = this.doIntersect(r1, r2);
        TextRegionTest.assertRegionEquals(inter, 3, 0);
        Assertions.assertTrue((boolean)inter.isEmpty());
    }

    @Test
    void testIntersectZeroLen4() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)0, (int)0);
        TextRegion inter = this.doIntersect(r1, r1);
        Assertions.assertEquals((Object)r1, (Object)inter);
    }

    @Test
    void testNonEmptyIntersect() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)3, (int)4);
        TextRegion r2 = TextRegion.fromOffsetLength((int)0, (int)5);
        TextRegion inter = this.doIntersect(r1, r2);
        TextRegionTest.assertRegionEquals(inter, 3, 2);
    }

    @Test
    void testIntersectContained() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)5);
        TextRegion r2 = TextRegion.fromOffsetLength((int)3, (int)1);
        TextRegion inter = this.doIntersect(r1, r2);
        TextRegionTest.assertRegionEquals(inter, 3, 1);
    }

    @Test
    void testIntersectDisjoint() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)4, (int)3);
        TextRegion r2 = TextRegion.fromOffsetLength((int)2, (int)1);
        this.noIntersect(r1, r2);
    }

    @Test
    void testOverlapContained() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)5);
        TextRegion r2 = TextRegion.fromOffsetLength((int)3, (int)1);
        TextRegionTest.assertOverlap(r1, r2);
    }

    @Test
    void testOverlapDisjoint() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)4, (int)3);
        TextRegion r2 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegionTest.assertNoOverlap(r1, r2);
    }

    @Test
    void testOverlapBoundary() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)3, (int)3);
        TextRegion r2 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegionTest.assertNoOverlap(r1, r2);
    }

    @Test
    void testCompare() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = TextRegion.fromOffsetLength((int)3, (int)3);
        TextRegionTest.assertIsBefore(r1, r2);
    }

    @Test
    void testCompareSameOffset() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)0, (int)1);
        TextRegion r2 = TextRegion.fromOffsetLength((int)0, (int)3);
        TextRegionTest.assertIsBefore(r1, r2);
    }

    @Test
    void testUnion() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = TextRegion.fromOffsetLength((int)3, (int)3);
        TextRegion union = this.doUnion(r1, r2);
        TextRegionTest.assertRegionEquals(union, 2, 4);
    }

    @Test
    void testUnionDisjoint() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = TextRegion.fromOffsetLength((int)5, (int)3);
        TextRegion union = this.doUnion(r1, r2);
        TextRegionTest.assertRegionEquals(union, 2, 6);
    }

    @Test
    void testGrowLeft() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = r1.growLeft(2);
        TextRegionTest.assertRegionEquals(r2, 0, 3);
    }

    @Test
    void testGrowLeftNegative() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = r1.growLeft(-1);
        TextRegionTest.assertRegionEquals(r2, 3, 0);
    }

    @Test
    void testGrowLeftOutOfBounds() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        Assertions.assertThrows(AssertionError.class, () -> r1.growLeft(4));
    }

    @Test
    void testGrowRight() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = r1.growRight(1);
        TextRegionTest.assertRegionEquals(r2, 2, 2);
    }

    @Test
    void testGrowRightNegative() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        TextRegion r2 = r1.growRight(-1);
        TextRegionTest.assertRegionEquals(r2, 2, 0);
    }

    @Test
    void testGrowRightOutOfBounds() {
        TextRegion r1 = TextRegion.fromOffsetLength((int)2, (int)1);
        Assertions.assertThrows(AssertionError.class, () -> r1.growRight(-2));
    }

    private static void assertRegionEquals(TextRegion region, int start, int len) {
        Assertions.assertEquals((int)start, (int)region.getStartOffset(), (String)"Start offset");
        Assertions.assertEquals((int)len, (int)region.getLength(), (String)"Length");
    }

    private static void assertIsBefore(TextRegion r1, TextRegion r2) {
        Assertions.assertTrue((r1.compareTo(r2) < 0 ? 1 : 0) != 0, (String)("Region " + r1 + " should be before " + r2));
        Assertions.assertTrue((r2.compareTo(r1) > 0 ? 1 : 0) != 0, (String)("Region " + r2 + " should be after " + r1));
    }

    private static void assertNoOverlap(TextRegion r1, TextRegion r2) {
        Assertions.assertFalse((boolean)r1.overlaps(r2), (String)("Regions " + r1 + " and " + r2 + " should not overlap"));
    }

    private static void assertOverlap(TextRegion r1, TextRegion r2) {
        Assertions.assertTrue((boolean)r1.overlaps(r2), (String)("Regions " + r1 + " and " + r2 + " should overlap"));
    }

    private TextRegion doIntersect(TextRegion r1, TextRegion r2) {
        TextRegion inter = TextRegion.intersect((TextRegion)r1, (TextRegion)r2);
        Assertions.assertNotNull((Object)inter, (String)("Intersection of " + r1 + " and " + r2 + " must exist"));
        TextRegion symmetric = TextRegion.intersect((TextRegion)r2, (TextRegion)r1);
        Assertions.assertEquals((Object)inter, (Object)symmetric, (String)("Intersection of " + r1 + " and " + r2 + " must be symmetric"));
        return inter;
    }

    private TextRegion doUnion(TextRegion r1, TextRegion r2) {
        TextRegion union = TextRegion.union((TextRegion)r1, (TextRegion)r2);
        Assertions.assertTrue((boolean)union.contains(r1), (String)("Union of " + r1 + " and " + r2 + " must contain first region"));
        Assertions.assertTrue((boolean)union.contains(r2), (String)("Union of " + r1 + " and " + r2 + " must contain second region"));
        TextRegion symmetric = TextRegion.union((TextRegion)r2, (TextRegion)r1);
        Assertions.assertEquals((Object)union, (Object)symmetric, (String)("Union of " + r1 + " and " + r2 + " must be symmetric"));
        return union;
    }

    private void noIntersect(TextRegion r1, TextRegion r2) {
        TextRegion inter = TextRegion.intersect((TextRegion)r1, (TextRegion)r2);
        Assertions.assertNull((Object)inter, (String)("Intersection of " + r1 + " and " + r2 + " must not exist"));
        TextRegion symmetric = TextRegion.intersect((TextRegion)r2, (TextRegion)r1);
        Assertions.assertEquals((Object)inter, (Object)symmetric, (String)("Intersection of " + r1 + " and " + r2 + " must be symmetric"));
    }
}

