/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.document.TextPos2d;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TextPos2dTest {
    TextPos2dTest() {
    }

    @Test
    void testToString() {
        TextPos2d pos = TextPos2d.pos2d((int)1, (int)2);
        Assertions.assertEquals((Object)"line 1, column 2", (Object)pos.toDisplayStringInEnglish());
        Assertions.assertEquals((Object)"1:2", (Object)pos.toDisplayStringWithColon());
        Assertions.assertEquals((Object)"(line=1, column=2)", (Object)pos.toTupleString());
        MatcherAssert.assertThat((Object)pos.toString(), (Matcher)CoreMatchers.containsString((String)"!debug only!"));
    }

    @Test
    void testEquals() {
        TextPos2d pos = TextPos2d.pos2d((int)1, (int)1);
        TextPos2d pos2 = TextPos2d.pos2d((int)1, (int)2);
        Assertions.assertNotEquals((Object)pos, (Object)pos2);
        Assertions.assertEquals((Object)pos, (Object)TextPos2d.pos2d((int)1, (int)1));
        Assertions.assertEquals((Object)pos2, (Object)pos2);
    }

    @Test
    void testCompareTo() {
        TextPos2d pos = TextPos2d.pos2d((int)1, (int)1);
        TextPos2d pos2 = TextPos2d.pos2d((int)1, (int)2);
        TextPos2d pos3 = TextPos2d.pos2d((int)2, (int)1);
        Assertions.assertEquals((int)-1, (int)pos.compareTo(pos2));
        Assertions.assertEquals((int)-1, (int)pos.compareTo(pos3));
        Assertions.assertEquals((int)-1, (int)pos2.compareTo(pos3));
        Assertions.assertEquals((int)1, (int)pos2.compareTo(pos));
        Assertions.assertEquals((int)0, (int)pos.compareTo(pos));
    }
}

