/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.ReadOnlyFileException;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextFileContent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TextFilesTest {
    @TempDir
    Path tempDir;

    TextFilesTest() {
    }

    @Test
    void testNioFile() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some content");
        try (TextFile tf = TextFile.forPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)file.toAbsolutePath().toUri().toString(), (Object)tf.getFileId().getUriString());
            Assertions.assertEquals((Object)file.toString(), (Object)tf.getFileId().getOriginalPath());
            Assertions.assertEquals((Object)file.getFileName().toString(), (Object)tf.getFileId().getFileName());
            Assertions.assertEquals((Object)PmdCoreTestUtils.dummyVersion(), (Object)tf.getLanguageVersion());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some content"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testEquals() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some content").toAbsolutePath();
        try (TextFile tf = TextFile.forPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion());
             TextFile tfPrime = TextFile.forPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion());
             TextFile stringTf = TextFile.forCharSeq((CharSequence)"some content", (FileId)FileId.fromPath((Path)file), (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)tf.getFileId(), (Object)stringTf.getFileId());
            Assertions.assertNotEquals((Object)tf, (Object)stringTf);
            Assertions.assertNotEquals((Object)stringTf, (Object)tf);
            Assertions.assertNotEquals((Object)stringTf, (Object)TextFile.forCharSeq((CharSequence)"some content", (FileId)FileId.fromPath((Path)file), (LanguageVersion)PmdCoreTestUtils.dummyVersion()));
            Assertions.assertNotSame((Object)tf, (Object)tfPrime);
            Assertions.assertEquals((Object)tf, (Object)tfPrime);
            Assertions.assertEquals((Object)tfPrime, (Object)tf);
            Assertions.assertEquals((int)tf.hashCode(), (int)tfPrime.hashCode());
        }
    }

    @Test
    void testNioFileWrite() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some content");
        try (TextFile tf = TextFile.forPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some content"), (Object)tf.readContents().getNormalizedText());
            Assertions.assertFalse((boolean)tf.isReadOnly(), (String)"readonly");
            tf.writeContents(TextFileContent.fromCharSeq((CharSequence)"new content\r\n"));
            TextFileContent read = tf.readContents();
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"new content\n"), (Object)read.getNormalizedText());
            Assertions.assertEquals((Object)"\r\n", (Object)read.getLineTerminator());
            tf.writeContents(TextFileContent.fromCharSeq((CharSequence)"new content\n"));
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"new content\n"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testNioFileExplicitReadOnly() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some content");
        try (TextFile tf = TextFile.builderForPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion()).asReadOnly().build();){
            Assertions.assertTrue((boolean)tf.isReadOnly(), (String)"readonly");
            Assertions.assertThrows(ReadOnlyFileException.class, () -> tf.writeContents(TextFileContent.fromCharSeq((CharSequence)"new content")));
        }
    }

    @Test
    void testNioFileCanBeReadMultipleTimes() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some content");
        try (TextFile tf = TextFile.forPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some content"), (Object)tf.readContents().getNormalizedText());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some content"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testNioFileBuilder() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some content");
        try (TextFile tf = TextFile.builderForPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion()).build();){
            Assertions.assertEquals((Object)file.toAbsolutePath().toUri().toString(), (Object)tf.getFileId().getUriString());
            Assertions.assertEquals((Object)PmdCoreTestUtils.dummyVersion(), (Object)tf.getLanguageVersion());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some content"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testNioFileEscape() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some\r\ncontent");
        try (TextFile tf = TextFile.forPath((Path)file, (Charset)StandardCharsets.UTF_8, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some\ncontent"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testReaderFile() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some\r\ncontent");
        try (TextFile tf = TextFile.forReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8), (FileId)FileId.UNKNOWN, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)FileId.UNKNOWN, (Object)tf.getFileId());
            Assertions.assertEquals((Object)PmdCoreTestUtils.dummyVersion(), (Object)tf.getLanguageVersion());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"some\ncontent"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testReaderFileIsReadOnly() throws IOException {
        Path file = this.makeTmpFile(StandardCharsets.UTF_8, "some\r\ncontent");
        try (TextFile tf = TextFile.forReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8), (FileId)FileId.UNKNOWN, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertTrue((boolean)tf.isReadOnly(), (String)"readonly");
            Assertions.assertThrows(ReadOnlyFileException.class, () -> tf.writeContents(TextFileContent.fromCharSeq((CharSequence)"new content")));
        }
    }

    @Test
    void testStringFileEscape() throws IOException {
        try (TextFile tf = TextFile.forCharSeq((CharSequence)"cont\r\nents", (FileId)FileId.UNKNOWN, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)FileId.UNKNOWN, (Object)tf.getFileId());
            Assertions.assertEquals((Object)PmdCoreTestUtils.dummyVersion(), (Object)tf.getLanguageVersion());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"cont\nents"), (Object)tf.readContents().getNormalizedText());
            Assertions.assertThrows(ReadOnlyFileException.class, () -> tf.writeContents(TextFileContent.fromCharSeq((CharSequence)"new content")));
        }
    }

    @Test
    void testStringFileCanBeReadMultipleTimes() throws IOException {
        try (TextFile tf = TextFile.forCharSeq((CharSequence)"contents", (FileId)FileId.UNKNOWN, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"contents"), (Object)tf.readContents().getNormalizedText());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"contents"), (Object)tf.readContents().getNormalizedText());
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"contents"), (Object)tf.readContents().getNormalizedText());
        }
    }

    @Test
    void testStringFileIsReadonly() throws IOException {
        try (TextFile tf = TextFile.forCharSeq((CharSequence)"contents", (FileId)FileId.UNKNOWN, (LanguageVersion)PmdCoreTestUtils.dummyVersion());){
            Assertions.assertTrue((boolean)tf.isReadOnly(), (String)"readonly");
            Assertions.assertThrows(ReadOnlyFileException.class, () -> tf.writeContents(TextFileContent.fromCharSeq((CharSequence)"new content")));
        }
    }

    private @NonNull Path makeTmpFile(Charset charset, String content) throws IOException {
        Path file = Files.createTempFile(this.tempDir, null, null, new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, new OpenOption[0]);){
            writer.write(content);
        }
        return file;
    }
}

