/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import java.io.Reader;
import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TextDocumentTest {
    TextDocumentTest() {
    }

    @Test
    void testSingleLineRegion() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)0, (int)"bonjour".length());
        Assertions.assertEquals((int)0, (int)region.getStartOffset());
        Assertions.assertEquals((int)"bonjour".length(), (int)region.getLength());
        Assertions.assertEquals((int)"bonjour".length(), (int)region.getEndOffset());
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)1, (int)withLines.getStartLine());
        Assertions.assertEquals((int)1, (int)withLines.getEndLine());
        Assertions.assertEquals((int)1, (int)withLines.getStartColumn());
        Assertions.assertEquals((int)(1 + "bonjour".length()), (int)withLines.getEndColumn());
        Assertions.assertEquals((int)"bonjour".length(), (int)(withLines.getEndColumn() - withLines.getStartColumn()));
    }

    @Test
    void testRegionAtEol() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)0, (int)"bonjour\n".length());
        Assertions.assertEquals((Object)"bonjour\n", (Object)doc.sliceOriginalText(region).toString());
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)1, (int)withLines.getStartLine());
        Assertions.assertEquals((int)1, (int)withLines.getEndLine());
        Assertions.assertEquals((int)1, (int)withLines.getStartColumn());
        Assertions.assertEquals((int)(1 + "bonjour\n".length()), (int)withLines.getEndColumn());
        Assertions.assertEquals((int)"bonjour\n".length(), (int)(withLines.getEndColumn() - withLines.getStartColumn()));
    }

    @Test
    void testEmptyRegionAtEol() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)"bonjour\n".length(), (int)0);
        Assertions.assertEquals((Object)"", (Object)doc.sliceOriginalText(region).toString());
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)2, (int)withLines.getStartLine());
        Assertions.assertEquals((int)2, (int)withLines.getEndLine());
        Assertions.assertEquals((int)1, (int)withLines.getStartColumn());
        Assertions.assertEquals((int)1, (int)withLines.getEndColumn());
    }

    @Test
    void testRegionForEol() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)"bonjour".length(), (int)1);
        Assertions.assertEquals((Object)"\n", (Object)doc.sliceOriginalText(region).toString());
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)1, (int)withLines.getStartLine());
        Assertions.assertEquals((int)1, (int)withLines.getEndLine());
        Assertions.assertEquals((int)(1 + "bonjour".length()), (int)withLines.getStartColumn());
        Assertions.assertEquals((int)(1 + "bonjour\n".length()), (int)withLines.getEndColumn());
    }

    @Test
    void testRegionAtEndOfFile() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"flemme", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)0, (int)doc.getLength());
        Assertions.assertEquals((Object)doc.getText(), (Object)doc.sliceOriginalText(region));
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)1, (int)withLines.getStartLine());
        Assertions.assertEquals((int)1, (int)withLines.getEndLine());
        Assertions.assertEquals((int)1, (int)withLines.getStartColumn());
        Assertions.assertEquals((int)(1 + doc.getLength()), (int)withLines.getEndColumn());
    }

    @Test
    void testMultiLineRegion() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\noha\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)"bonjou".length(), (int)"r\noha\ntri".length());
        Assertions.assertEquals((int)"bonjou".length(), (int)region.getStartOffset());
        Assertions.assertEquals((int)"r\noha\ntri".length(), (int)region.getLength());
        Assertions.assertEquals((int)"bonjour\noha\ntri".length(), (int)region.getEndOffset());
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)1, (int)withLines.getStartLine());
        Assertions.assertEquals((int)3, (int)withLines.getEndLine());
        Assertions.assertEquals((int)(1 + "bonjou".length()), (int)withLines.getStartColumn());
        Assertions.assertEquals((int)(1 + "tri".length()), (int)withLines.getEndColumn());
    }

    @Test
    void testLineColumnFromOffset() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"ab\ncd\n", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        this.assertPos2dEqualsAt(doc, 0, "a", TextPos2d.pos2d((int)1, (int)1), true);
        this.assertPos2dEqualsAt(doc, 0, "a", TextPos2d.pos2d((int)1, (int)1), false);
        this.assertPos2dEqualsAt(doc, 1, "b", TextPos2d.pos2d((int)1, (int)2), true);
        this.assertPos2dEqualsAt(doc, 2, "\n", TextPos2d.pos2d((int)1, (int)3), true);
        this.assertPos2dEqualsAt(doc, 3, "c", TextPos2d.pos2d((int)2, (int)1), true);
        this.assertPos2dEqualsAt(doc, 3, "c", TextPos2d.pos2d((int)1, (int)4), false);
        this.assertPos2dEqualsAt(doc, 4, "d", TextPos2d.pos2d((int)2, (int)2), true);
        this.assertPos2dEqualsAt(doc, 5, "\n", TextPos2d.pos2d((int)2, (int)3), true);
        Assertions.assertEquals((Object)TextPos2d.pos2d((int)3, (int)1), (Object)doc.lineColumnAtOffset(6));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> doc.lineColumnAtOffset(7));
    }

    private void assertPos2dEqualsAt(TextDocument doc, int offset, String c, TextPos2d pos, boolean inclusive) {
        Chars slicedChar = doc.sliceTranslatedText(TextRegion.fromOffsetLength((int)offset, (int)1));
        Assertions.assertEquals((Object)c, (Object)slicedChar.toString());
        Assertions.assertEquals((Object)pos, (Object)doc.lineColumnAtOffset(offset, inclusive));
    }

    @Test
    void testEmptyRegion() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\noha\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        TextRegion region = TextRegion.fromOffsetLength((int)"bonjour".length(), (int)0);
        Assertions.assertEquals((int)"bonjour".length(), (int)region.getStartOffset());
        Assertions.assertEquals((int)0, (int)region.getLength());
        Assertions.assertEquals((int)region.getStartOffset(), (int)region.getEndOffset());
        FileLocation withLines = doc.toLocation(region);
        Assertions.assertEquals((int)1, (int)withLines.getStartLine());
        Assertions.assertEquals((int)1, (int)withLines.getEndLine());
        Assertions.assertEquals((int)(1 + "bonjour".length()), (int)withLines.getStartColumn());
        Assertions.assertEquals((int)(1 + "bonjour".length()), (int)withLines.getEndColumn());
    }

    @Test
    void testLineRange() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\noha\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"bonjour\n"), (Object)doc.sliceTranslatedText(doc.createLineRange(1, 1)));
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"bonjour\noha\n"), (Object)doc.sliceTranslatedText(doc.createLineRange(1, 2)));
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"oha\n"), (Object)doc.sliceTranslatedText(doc.createLineRange(2, 2)));
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"oha\ntristesse"), (Object)doc.sliceTranslatedText(doc.createLineRange(2, 3)));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> doc.createLineRange(2, 1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> doc.createLineRange(1, 5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> doc.createLineRange(0, 2));
    }

    @ParameterizedTest
    @MethodSource(value={"documentProvider"})
    void testEntireRegion(TextDocument doc) {
        Assertions.assertEquals((Object)TextRegion.fromOffsetLength((int)0, (int)doc.getLength()), (Object)doc.getEntireRegion(), (String)"getEntireRegion should return something based on length");
    }

    @ParameterizedTest
    @MethodSource(value={"documentProvider"})
    void testReader(TextDocument doc) throws IOException {
        Assertions.assertEquals((Object)doc.getText().toString(), (Object)IOUtil.readToString((Reader)doc.newReader()), (String)"NewReader should read the text");
    }

    @Test
    void testRegionOutOfBounds() {
        TextDocument doc = TextDocument.readOnlyString((CharSequence)"bonjour\noha\ntristesse", (LanguageVersion)PmdCoreTestUtils.dummyVersion());
        Assertions.assertThrows(AssertionError.class, () -> TextRegion.isValidRegion((int)0, (int)40, (TextDocument)doc));
    }

    static Object[] documentProvider() {
        LanguageVersion dummyVersion = DummyLanguageModule.getInstance().getDefaultVersion();
        return new TextDocument[]{TextDocument.readOnlyString((CharSequence)"bonjour\noha\ntristesse", (LanguageVersion)dummyVersion), TextDocument.readOnlyString((CharSequence)"bonjour\n", (LanguageVersion)dummyVersion), TextDocument.readOnlyString((CharSequence)"\n", (LanguageVersion)dummyVersion), TextDocument.readOnlyString((CharSequence)"", (LanguageVersion)dummyVersion)};
    }
}

