/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.lang.document.TestMessageReporter;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class NioTextFileTest {
    @TempDir
    private Path tempDir;

    NioTextFileTest() {
    }

    @Test
    void zipFileDisplayName() throws Exception {
        Path zipArchive = this.tempDir.resolve("sources.zip");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipArchive.toFile()));){
            ZipEntry zipEntry = new ZipEntry("path/inside/someSource.dummy");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write("dummy text".getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
        }
        PMDConfiguration config = new PMDConfiguration();
        config.setReporter((PmdReporter)new TestMessageReporter());
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.files().addZipFileWithContent(zipArchive);
            List collectedFiles = pmd.files().getCollectedFiles();
            Assertions.assertEquals((int)1, (int)collectedFiles.size());
            TextFile textFile = (TextFile)collectedFiles.get(0);
            Assertions.assertEquals((Object)(zipArchive.toAbsolutePath() + "!/path/inside/someSource.dummy"), (Object)pmd.fileNameRenderer().getDisplayName(textFile));
        }
    }
}

