/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FragmentedDocBuilder;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FragmentedTextDocumentTest {
    LanguageVersion dummyVersion = DummyLanguageModule.getInstance().getDefaultVersion();

    FragmentedTextDocumentTest() {
    }

    @Test
    void testSimple() throws IOException {
        try (TextDocument base = TextDocument.readOnlyString((CharSequence)"abc", (LanguageVersion)this.dummyVersion);){
            FragmentedDocBuilder builder = new FragmentedDocBuilder(base);
            builder.recordDelta(1, 2, Chars.wrap((CharSequence)"abx"));
            try (TextDocument doc = builder.build();){
                Assertions.assertEquals((Object)"aabxc", (Object)doc.getText().toString());
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)1), (Object)doc.lineColumnAtOffset(0));
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)2), (Object)doc.lineColumnAtOffset(1, true));
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)3), (Object)doc.lineColumnAtOffset(2, true));
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)3), (Object)doc.lineColumnAtOffset(2, false));
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)4), (Object)doc.lineColumnAtOffset(3, true));
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)4), (Object)doc.lineColumnAtOffset(3, false));
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)4), (Object)doc.lineColumnAtOffset(5));
            }
        }
    }

    @Test
    void testToLocationWithCaret() throws IOException {
        try (TextDocument base = TextDocument.readOnlyString((CharSequence)"abc", (LanguageVersion)this.dummyVersion);){
            FragmentedDocBuilder builder = new FragmentedDocBuilder(base);
            builder.recordDelta(1, 2, Chars.wrap((CharSequence)"abx"));
            try (TextDocument doc = builder.build();){
                Assertions.assertEquals((Object)"aabxc", (Object)doc.getText().toString());
                TextRegion region = TextRegion.caretAt((int)4);
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)3), (Object)doc.toLocation(region).getStartPos());
            }
        }
    }

    @Test
    void testToLocationWithCaretBetweenEscapes() throws IOException {
        try (TextDocument base = TextDocument.readOnlyString((CharSequence)"aBBCCd", (LanguageVersion)this.dummyVersion);){
            FragmentedDocBuilder builder = new FragmentedDocBuilder(base);
            builder.recordDelta(1, 3, Chars.wrap((CharSequence)"X"));
            builder.recordDelta(3, 5, Chars.wrap((CharSequence)"Y"));
            try (TextDocument doc = builder.build();){
                Assertions.assertEquals((Object)"aXYd", (Object)doc.getText().toString());
                TextRegion region = TextRegion.caretAt((int)2);
                Assertions.assertEquals((Object)TextPos2d.pos2d((int)1, (int)4), (Object)doc.toLocation(region).getStartPos());
            }
        }
    }

    @Test
    void offsetAtLineColumn() throws IOException {
        try (TextDocument base = TextDocument.readOnlyString((CharSequence)"ABC\n123\n", (LanguageVersion)this.dummyVersion);){
            FragmentedDocBuilder builder = new FragmentedDocBuilder(base);
            builder.recordDelta(3, 3, Chars.wrap((CharSequence)"X"));
            builder.recordDelta(7, 7, Chars.wrap((CharSequence)"Y"));
            try (TextDocument doc = builder.build();){
                Assertions.assertEquals((Object)"ABCX\n123Y\n", (Object)doc.getText().toString());
                Assertions.assertEquals((int)0, (int)doc.offsetAtLineColumn(TextPos2d.pos2d((int)1, (int)1)));
                Assertions.assertEquals((int)0, (int)base.offsetAtLineColumn(TextPos2d.pos2d((int)1, (int)1)));
                Assertions.assertEquals((int)4, (int)doc.offsetAtLineColumn(TextPos2d.pos2d((int)2, (int)1)));
                Assertions.assertEquals((int)4, (int)base.offsetAtLineColumn(TextPos2d.pos2d((int)2, (int)1)));
            }
        }
    }
}

