/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sourceforge.pmd.lang.document.FileId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileIdTest {
    FileIdTest() {
    }

    @Test
    void testFromPath() {
        Path path = Paths.get("/a", new String[0]);
        Path absPath = path.toAbsolutePath();
        FileId fileId = FileId.fromPath((Path)path);
        FileIdTest.checkId(fileId, absPath.toString(), "a", path.toUri().toString(), path.toString());
    }

    @Test
    void testFromUri() {
        Path absPath = Paths.get("/a/b.c", new String[0]);
        String uriStr = absPath.toUri().toString();
        FileId fileId = FileId.fromURI((String)uriStr);
        FileIdTest.checkId(fileId, absPath.toAbsolutePath().toString(), "b.c", uriStr, absPath.toAbsolutePath().toString());
    }

    @Test
    void testFromAsChild() {
        FileId parent = FileId.fromPathLikeString((String)"bla");
        FileId child = FileId.fromPathLikeString((String)"bla");
        FileId fileId = FileId.asChildOf((FileId)child, (FileId)parent);
        FileIdTest.checkId(fileId, child.getAbsolutePath(), "bla", child.getUriString(), "bla");
        Assertions.assertSame((Object)child, (Object)FileId.asChildOf((FileId)child, null));
        Assertions.assertSame((Object)fileId, (Object)FileId.asChildOf((FileId)fileId, (FileId)parent));
    }

    @Test
    void testFromUriForJar() {
        Path zipPath = Paths.get("/a/b.zip", new String[0]);
        String uriStr = "jar:" + zipPath.toUri() + "!/x/c.d";
        FileId fileId = FileId.fromURI((String)uriStr);
        String absLocalPath = "/x/c.d".replace('/', File.separatorChar);
        FileIdTest.checkId(fileId, absLocalPath, "c.d", uriStr, "/x/c.d");
        FileIdTest.checkId(fileId.getParentFsPath(), zipPath.toAbsolutePath().toString(), "b.zip", zipPath.toUri().toString(), zipPath.toAbsolutePath().toString());
    }

    private static void checkId(FileId fileId, String absPath, String fileName, String uri, String originalPath) {
        Assertions.assertNotNull((Object)fileId);
        Assertions.assertEquals((Object)absPath, (Object)fileId.getAbsolutePath(), (String)"absolute path");
        Assertions.assertEquals((Object)fileName, (Object)fileId.getFileName(), (String)"file name");
        Assertions.assertEquals((Object)uri, (Object)fileId.getUriString(), (String)"uri");
        Assertions.assertEquals((Object)originalPath, (Object)fileId.getOriginalPath(), (String)"original path");
    }
}

