/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.DummyTreeUtil;
import net.sourceforge.pmd.lang.ast.internal.AxisStream;
import net.sourceforge.pmd.lang.ast.internal.GreedyNStream;
import net.sourceforge.pmd.lang.ast.internal.SingletonNodeStream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NodeStreamTest {
    private final DummyNode tree1 = DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.nodeB(DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.nodeB(DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.node(DummyTreeUtil.node(new DummyNode[0])), DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.node(new DummyNode[0]))), DummyTreeUtil.node(new DummyNode[0])));
    private final DummyNode tree2 = DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.node(new DummyNode[0]), DummyTreeUtil.node(DummyTreeUtil.node(new DummyNode[0])), DummyTreeUtil.node(new DummyNode[0])));

    NodeStreamTest() {
    }

    @Test
    void testStreamConstructionIsNullSafe() {
        Assertions.assertTrue((boolean)NodeStream.of((Node)null).isEmpty());
        MatcherAssert.assertThat((Object)NodeStream.of((Node[])new DummyNode[]{null, null, this.tree1}).count(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)NodeStream.fromIterable(Arrays.asList(this.tree1, null, null)).count(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)NodeStream.ofOptional(Optional.empty()).count(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void testMapIsNullSafe() {
        Assertions.assertTrue((boolean)this.tree1.descendantsOrSelf().map(n -> null).isEmpty());
    }

    @Test
    void testFlatMapIsNullSafe() {
        Assertions.assertTrue((boolean)this.tree1.descendantsOrSelf().flatMap(n -> null).isEmpty());
    }

    @Test
    void testChildrenStream() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(this.tree1.children()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "1"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(this.tree1.asStream().children()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "1"}));
    }

    @Test
    void testChildrenEagerEvaluation() {
        NodeStream children = this.tree1.children();
        MatcherAssert.assertThat((Object)children, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AxisStream.ChildrenStream.class)));
        NodeStream children1 = children.children();
        Assertions.assertEquals(GreedyNStream.GreedyKnownNStream.class, children1.getClass());
        Assertions.assertEquals(SingletonNodeStream.class, children1.filter(it -> it.getImage().endsWith("1")).getClass());
    }

    @Test
    void testDescendantStream() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(this.tree1.descendants()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "00", "01", "010", "011", "0110", "012", "013", "1"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(this.tree1.asStream().descendants()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "00", "01", "010", "011", "0110", "012", "013", "1"}));
    }

    @Test
    void testSingletonStream() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(this.tree1.asStream()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{""}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(NodeStream.of((Node)this.tree1)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{""}));
    }

    @Test
    void testDescendantOrSelfStream() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(this.tree1.descendantsOrSelf()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"", "0", "00", "01", "010", "011", "0110", "012", "013", "1"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(NodeStream.of((Node)this.tree1).descendantsOrSelf()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"", "0", "00", "01", "010", "011", "0110", "012", "013", "1"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree1, "0110").descendantsOrSelf()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0110"}));
    }

    @Test
    void testAncestors() {
        Node node = this.tree1.children().children().children().first();
        Assertions.assertEquals((Object)"010", (Object)node.getImage());
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(node.ancestors()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"01", "0", ""}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(node.ancestorsOrSelf()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"010", "01", "0", ""}));
        Assertions.assertEquals((Object)"01", (Object)node.ancestors().get(0).getImage());
        Assertions.assertEquals((Object)"0", (Object)node.ancestors().get(1).getImage());
        Assertions.assertEquals((Object)"", (Object)node.ancestors().get(2).getImage());
        Assertions.assertNull((Object)node.ancestors().get(3));
    }

    @Test
    void testAncestorsFiltered() {
        Node node = this.tree1.children().children().children().children().first();
        Assertions.assertEquals((Object)"0110", (Object)node.getImage());
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(node.ancestors(DummyNode.DummyNodeTypeB.class)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"01", "0"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(node.ancestorsOrSelf().filterIs(DummyNode.DummyNodeTypeB.class)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"01", "0"}));
    }

    @Test
    void testAncestorsFilteredDrop() {
        Node node = this.tree1.children().children().children().children().first();
        Assertions.assertEquals((Object)"0110", (Object)node.getImage());
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(node.ancestors(DummyNode.DummyNodeTypeB.class).drop(1)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(node.ancestorsOrSelf().filterIs(DummyNode.DummyNodeTypeB.class).drop(1)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0"}));
    }

    @Test
    void testFollowingSiblings() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree2, "2").asStream().followingSiblings()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"3"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree2, "0").asStream().followingSiblings()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"1", "2", "3"}));
        Assertions.assertTrue((boolean)DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree2, "3").asStream().followingSiblings()).isEmpty());
    }

    @Test
    void testPrecedingSiblings() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree2, "2").asStream().precedingSiblings()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "1"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree2, "3").asStream().precedingSiblings()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "1", "2"}));
        Assertions.assertTrue((boolean)DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree2, "0").asStream().precedingSiblings()).isEmpty());
    }

    @Test
    void testRootSiblings() {
        Assertions.assertTrue((boolean)this.tree2.asStream().precedingSiblings().isEmpty());
        Assertions.assertTrue((boolean)this.tree2.asStream().followingSiblings().isEmpty());
    }

    @Test
    void testAncestorStream() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree1, "01").ancestors()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", ""}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree1, "01").asStream().ancestors()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", ""}));
    }

    @Test
    void testParentStream() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(DummyTreeUtil.followPath(this.tree1, "01").asStream().parents()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0"}));
    }

    @Test
    void testAncestorStreamUnion() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(NodeStream.union((NodeStream[])new NodeStream[]{DummyTreeUtil.followPath(this.tree1, "01").ancestors(), this.tree2.children().ancestors()})), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "", "", "", "", ""}));
    }

    @Test
    void testDistinct() {
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(NodeStream.union((NodeStream[])new NodeStream[]{DummyTreeUtil.followPath(this.tree1, "01").ancestors(), this.tree2.children().ancestors()}).distinct()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "", ""}));
    }

    @Test
    void testGet() {
        NodeStream.DescendantNodeStream stream = this.tree1.descendants();
        Assertions.assertEquals((Object)"0", (Object)((DummyNode)stream.get(0)).getImage());
        Assertions.assertEquals((Object)"00", (Object)((DummyNode)stream.get(1)).getImage());
        Assertions.assertEquals((Object)"010", (Object)((DummyNode)stream.get(3)).getImage());
        Assertions.assertEquals((Object)"011", (Object)((DummyNode)stream.get(4)).getImage());
        Assertions.assertEquals((Object)"0110", (Object)((DummyNode)stream.get(5)).getImage());
        Assertions.assertNull((Object)stream.get(9));
    }

    @Test
    void testNodeStreamsCanBeIteratedSeveralTimes() {
        NodeStream.DescendantNodeStream stream = this.tree1.descendants();
        MatcherAssert.assertThat((Object)stream.count(), (Matcher)CoreMatchers.equalTo((Object)9));
        MatcherAssert.assertThat((Object)stream.count(), (Matcher)CoreMatchers.equalTo((Object)9));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(stream), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"0", "00", "01", "010", "011", "0110", "012", "013", "1"}));
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(stream.filter(n -> n.getNumChildren() == 0)), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"00", "010", "0110", "012", "013", "1"}));
    }

    @Test
    void testNodeStreamPipelineIsLazy() {
        MutableInt numEvals = new MutableInt();
        this.tree1.descendants().filter(n -> {
            numEvals.increment();
            return true;
        });
        MatcherAssert.assertThat((Object)numEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void testForkJoinUpstreamPipelineIsExecutedAtMostOnce() {
        MutableInt numEvals = new MutableInt();
        NodeStream stream = NodeStream.forkJoin(NodeStreamTest.hook(() -> ((MutableInt)numEvals).increment(), this.tree1.descendants()), n -> NodeStream.of((Node)n).filter(m -> m.hasImageEqualTo("0")), n -> NodeStream.of((Node)n).filter(m -> m.hasImageEqualTo("1")), (Function[])new Function[0]);
        MatcherAssert.assertThat((Object)stream.count(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)numEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)9));
        MatcherAssert.assertThat((Object)stream.count(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)numEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)9));
    }

    @Test
    void testCachedStreamUpstreamPipelineIsExecutedAtMostOnce() {
        MutableInt upstreamEvals = new MutableInt();
        MutableInt downstreamEvals = new MutableInt();
        NodeStream stream = this.tree1.descendants().filter(n -> n.getImage().matches("0.*")).take(4).peek(n -> upstreamEvals.increment()).cached().filter(n -> true).peek(n -> downstreamEvals.increment());
        MatcherAssert.assertThat((Object)stream.count(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)upstreamEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)downstreamEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)stream.count(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)upstreamEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)downstreamEvals.getValue(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    void testUnionIsLazy() {
        MutableInt tree1Evals = new MutableInt();
        MutableInt tree2Evals = new MutableInt();
        NodeStream unionStream = NodeStream.union((NodeStream[])new NodeStream[]{this.tree1.descendantsOrSelf().peek(n -> tree1Evals.increment()), this.tree2.descendantsOrSelf().peek(n -> tree2Evals.increment())});
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)tree2Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assertions.assertSame((Object)unionStream.first(), (Object)((Object)this.tree1));
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)tree2Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void testSomeOperationsAreLazy() {
        MutableInt tree1Evals = new MutableInt();
        NodeStream unionStream = this.tree1.descendantsOrSelf().peek(n -> tree1Evals.increment());
        int i = 0;
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)i));
        unionStream.first();
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)(++i)));
        unionStream.nonEmpty();
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)i));
        unionStream.isEmpty();
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)i));
        unionStream.map(p -> p);
        unionStream.filter(p -> true);
        unionStream.append((NodeStream)this.tree2.descendantsOrSelf());
        unionStream.prepend((NodeStream)this.tree2.descendantsOrSelf());
        unionStream.flatMap(Node::descendantsOrSelf);
        unionStream.iterator();
        unionStream.descendants();
        unionStream.ancestors();
        unionStream.followingSiblings();
        unionStream.precedingSiblings();
        unionStream.children();
        unionStream.distinct();
        unionStream.take(4);
        unionStream.drop(4);
        MatcherAssert.assertThat((Object)tree1Evals.getValue(), (Matcher)CoreMatchers.equalTo((Object)i));
    }

    @Test
    void testFollowingSiblingsNonEmpty() {
        DummyNode node = DummyTreeUtil.followPath(this.tree1, "012");
        NodeStream nodes = node.asStream().followingSiblings();
        Assertions.assertTrue((boolean)(nodes instanceof SingletonNodeStream));
        Assertions.assertEquals((Object)"013", (Object)nodes.first().getImage());
    }

    @Test
    void testPrecedingSiblingsNonEmpty() {
        DummyNode node = DummyTreeUtil.followPath(this.tree1, "011");
        NodeStream nodes = node.asStream().precedingSiblings();
        Assertions.assertTrue((boolean)(nodes instanceof SingletonNodeStream));
        Assertions.assertEquals((Object)"010", (Object)nodes.first().getImage());
    }

    @Test
    void testPrecedingSiblingsDrop() {
        DummyNode node = DummyTreeUtil.followPath(this.tree1, "012");
        NodeStream nodes = node.asStream().precedingSiblings().drop(1);
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(nodes), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"011"}));
    }

    @Test
    void testFollowingSiblingsDrop() {
        DummyNode node = DummyTreeUtil.followPath(this.tree1, "011");
        NodeStream nodes = node.asStream().followingSiblings().drop(1);
        MatcherAssert.assertThat(DummyTreeUtil.pathsOf(nodes), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"013"}));
    }

    private static <T extends Node> NodeStream<T> hook(Runnable hook, NodeStream<T> stream) {
        return stream.filter(t -> {
            hook.run();
            return true;
        });
    }
}

