/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Optional;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.ast.internal.NodeFindingUtil;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NodeFindingUtilTest {
    NodeFindingUtilTest() {
    }

    @Test
    void testFindNode() {
        DummyNode.DummyRootNode root = NodeFindingUtilTest.parseLispish("(a(b)x(c))");
        NodeFindingUtilTest.assertFinds("a", 1, (Node)root);
        NodeFindingUtilTest.assertFinds("b", 2, (Node)root);
        NodeFindingUtilTest.assertFinds("b", 3, (Node)root);
        NodeFindingUtilTest.assertFinds("b", 4, (Node)root);
        NodeFindingUtilTest.assertFinds("a", 5, (Node)root);
        NodeFindingUtilTest.assertFinds("c", 6, (Node)root);
        NodeFindingUtilTest.assertFinds("c", 7, (Node)root);
        NodeFindingUtilTest.assertFinds("c", 8, (Node)root);
        NodeFindingUtilTest.assertFinds("a", 9, (Node)root);
        NodeFindingUtilTest.assertDoesNotFind(10, root);
    }

    private static void assertDoesNotFind(int offset, DummyNode.DummyRootNode root) {
        Assertions.assertFalse((boolean)NodeFindingUtil.findNodeAt((Node)root, (int)offset).isPresent());
    }

    static void assertFinds(String nodeImage, int offset, Node root) {
        Optional found = NodeFindingUtil.findNodeAt((Node)root, (int)offset);
        Assertions.assertTrue((boolean)found.isPresent(), (String)("Node not found: " + nodeImage + " at offset " + offset));
        MatcherAssert.assertThat((Object)((Node)found.get()).getImage(), (Matcher)Matchers.equalTo((Object)nodeImage));
    }

    static DummyNode.DummyRootNode parseLispish(String source) {
        DummyNode.DummyRootNode dummyRootNode;
        block8: {
            DummyLanguageModule lang = DummyLanguageModule.getInstance();
            LanguageProcessor processor = lang.createProcessor(lang.newPropertyBundle());
            try {
                Parser.ParserTask task = new Parser.ParserTask(TextDocument.readOnlyString((CharSequence)source, (LanguageVersion)lang.getDefaultVersion()), SemanticErrorReporter.noop(), LanguageProcessorRegistry.singleton((LanguageProcessor)processor));
                RootNode root = processor.services().getParser().parse(task);
                dummyRootNode = (DummyNode.DummyRootNode)root;
                if (processor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (processor != null) {
                        try {
                            processor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            processor.close();
        }
        return dummyRootNode;
    }
}

