/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import java.io.IOException;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaEscapeTranslator;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JavaEscapeReaderTest {
    JavaEscapeReaderTest() {
    }

    TextDocument readString(String input) {
        TextDocument intext = TextDocument.readOnlyString((CharSequence)Chars.wrap((CharSequence)input), (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion());
        return new JavaEscapeTranslator(intext).translateDocument();
    }

    @Test
    void testSimpleRead() throws IOException {
        String input = "abcdede";
        try (TextDocument r = this.readString(input);){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)input), (Object)r.getText());
        }
    }

    @Test
    void testNotAnEscape1Read() throws IOException {
        String input = "abc\\dede";
        try (TextDocument r = this.readString(input);){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)input), (Object)r.getText());
        }
    }

    @Test
    void testNotAnEscape1Read2() throws IOException {
        String input = "abc\\\\\\dede";
        try (TextDocument r = this.readString(input);){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)input), (Object)r.getText());
        }
    }

    @Test
    void testAnEscapeStopAtEnd() throws IOException {
        String input = "abc\\\\\\u00a0dede";
        try (TextDocument r = this.readString(input);){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"abc\u00a0dede"), (Object)r.getText());
        }
    }

    @Test
    void testSeveralEscapes() throws IOException {
        String input = "abc\\\\\\u00a0d\\uu00a0ede";
        try (TextDocument r = this.readString(input);){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"abc\u00a0d\u00a0ede"), (Object)r.getText());
        }
    }

    @Test
    void testAnEscapeInsideBlock() throws IOException {
        String input = "abc\\\\\\u00a0dede\\u00a0";
        try (TextDocument r = this.readString(input);){
            Assertions.assertEquals((Object)Chars.wrap((CharSequence)"abc\u00a0dede\u00a0"), (Object)r.getText());
        }
    }
}

