/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaEscapeTranslator;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CharStreamTest {
    private LanguageVersion dummyVersion = DummyLanguageModule.getInstance().getDefaultVersion();

    CharStreamTest() {
    }

    @Test
    void testReadZeroChars() throws IOException {
        CharStream stream = this.simpleCharStream("");
        Assertions.assertThrows(EOFException.class, () -> ((CharStream)stream).readChar());
        Assertions.assertEquals((int)stream.getStartOffset(), (int)0);
        Assertions.assertEquals((int)stream.getEndOffset(), (int)0);
    }

    @Test
    void testMultipleEofReads() throws IOException {
        CharStream stream = this.simpleCharStream("");
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThrows(EOFException.class, () -> ((CharStream)stream).readChar());
        }
    }

    @Test
    void testReadStuff() throws IOException {
        CharStream stream = this.simpleCharStream("abcd");
        Assertions.assertEquals((char)'a', (char)stream.readChar());
        Assertions.assertEquals((char)'b', (char)stream.readChar());
        Assertions.assertEquals((char)'c', (char)stream.readChar());
        Assertions.assertEquals((char)'d', (char)stream.readChar());
        Assertions.assertThrows(EOFException.class, () -> ((CharStream)stream).readChar());
    }

    @Test
    void testReadBacktrack() throws IOException {
        CharStream stream = this.simpleCharStream("abcd");
        Assertions.assertEquals((char)'a', (char)stream.markTokenStart());
        Assertions.assertEquals((char)'b', (char)stream.readChar());
        Assertions.assertEquals((char)'c', (char)stream.readChar());
        Assertions.assertEquals((char)'d', (char)stream.readChar());
        Assertions.assertEquals((Object)"abcd", (Object)stream.getTokenImage());
        stream.backup(2);
        Assertions.assertEquals((char)'c', (char)stream.readChar());
        Assertions.assertEquals((char)'d', (char)stream.readChar());
        Assertions.assertThrows(EOFException.class, () -> ((CharStream)stream).readChar());
    }

    @Test
    void testReadBacktrackWithEscapes() throws IOException {
        CharStream stream = this.javaCharStream("__\\u00a0_\\u00a0_");
        Assertions.assertEquals((char)'_', (char)stream.markTokenStart());
        Assertions.assertEquals((char)'_', (char)stream.readChar());
        Assertions.assertEquals((char)'\u00a0', (char)stream.readChar());
        Assertions.assertEquals((char)'_', (char)stream.readChar());
        Assertions.assertEquals((Object)"__\u00a0_", (Object)stream.getTokenImage());
        stream.backup(2);
        Assertions.assertEquals((char)'\u00a0', (char)stream.readChar());
        Assertions.assertEquals((char)'_', (char)stream.readChar());
        Assertions.assertEquals((char)'\u00a0', (char)stream.readChar());
        Assertions.assertEquals((Object)"__\u00a0_\u00a0", (Object)stream.getTokenImage());
        Assertions.assertEquals((char)'_', (char)stream.readChar());
        stream.backup(2);
        Assertions.assertEquals((char)'\u00a0', (char)stream.markTokenStart());
        Assertions.assertEquals((char)'_', (char)stream.readChar());
        Assertions.assertEquals((Object)"\u00a0_", (Object)stream.getTokenImage());
        Assertions.assertThrows(EOFException.class, () -> ((CharStream)stream).readChar());
    }

    @Test
    void testBacktrackTooMuch() throws IOException {
        CharStream stream = this.simpleCharStream("abcd");
        Assertions.assertEquals((char)'a', (char)stream.readChar());
        Assertions.assertEquals((char)'b', (char)stream.readChar());
        Assertions.assertEquals((char)'c', (char)stream.markTokenStart());
        Assertions.assertEquals((char)'d', (char)stream.readChar());
        stream.backup(2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> stream.backup(1));
    }

    @Test
    void testBacktrackTooMuch2() throws IOException {
        CharStream stream = this.simpleCharStream("abcd");
        Assertions.assertEquals((char)'a', (char)stream.markTokenStart());
        Assertions.assertEquals((char)'b', (char)stream.readChar());
        Assertions.assertEquals((char)'c', (char)stream.readChar());
        Assertions.assertEquals((char)'d', (char)stream.readChar());
        Assertions.assertThrows(IllegalArgumentException.class, () -> stream.backup(10));
    }

    CharStream simpleCharStream(String abcd) {
        return CharStream.create((TextDocument)TextDocument.readOnlyString((CharSequence)abcd, (LanguageVersion)this.dummyVersion), (JavaccTokenDocument.TokenDocumentBehavior)JavaccTokenDocument.TokenDocumentBehavior.DEFAULT);
    }

    CharStream javaCharStream(String abcd) {
        return CharStream.create((TextDocument)TextDocument.readOnlyString((CharSequence)abcd, (LanguageVersion)this.dummyVersion), (JavaccTokenDocument.TokenDocumentBehavior)new JavaccTokenDocument.TokenDocumentBehavior(Collections.emptyList()){

            public TextDocument translate(TextDocument text) throws MalformedSourceException {
                return new JavaEscapeTranslator(text).translateDocument();
            }
        });
    }
}

