/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.File;
import java.util.HashSet;
import net.sourceforge.pmd.lang.DummyLanguageDialectModule;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LanguageVersionDiscovererTest {
    LanguageVersionDiscovererTest() {
    }

    @Test
    void testFileLanguageIsUnknown() {
        DummyLanguageModule lang = DummyLanguageModule.getInstance();
        LanguageRegistry lr = LanguageRegistry.singleton((Language)lang);
        LanguageVersionDiscoverer lvDicoverer = new LanguageVersionDiscoverer(lr);
        LanguageVersion versionForFile = lvDicoverer.getDefaultLanguageVersionForFile(new File("file.unknown-extension"));
        Assertions.assertNull((Object)versionForFile);
    }

    @Test
    void testFileLanguageIsDetected() {
        DummyLanguageModule lang = DummyLanguageModule.getInstance();
        LanguageRegistry lr = LanguageRegistry.singleton((Language)lang);
        LanguageVersionDiscoverer lvDicoverer = new LanguageVersionDiscoverer(lr);
        LanguageVersion versionForFile = lvDicoverer.getDefaultLanguageVersionForFile(new File("file.txt"));
        Assertions.assertNotNull((Object)versionForFile);
        Assertions.assertSame((Object)((Object)lang), (Object)versionForFile.getLanguage());
        Assertions.assertEquals((Object)lang.getDefaultVersion().getVersion(), (Object)versionForFile.getVersion());
    }

    @Test
    void testDialectTakesPrecedence() {
        DummyLanguageModule lang = DummyLanguageModule.getInstance();
        DummyLanguageDialectModule dialect = DummyLanguageDialectModule.getInstance();
        HashSet<Object> langSet = new HashSet<Object>();
        langSet.add((Object)lang);
        langSet.add((Object)dialect);
        LanguageRegistry lr = new LanguageRegistry(langSet);
        LanguageVersionDiscoverer lvDicoverer = new LanguageVersionDiscoverer(lr);
        LanguageVersion versionForFile = lvDicoverer.getDefaultLanguageVersionForFile(new File("file.txt"));
        Assertions.assertNotNull((Object)versionForFile);
        Assertions.assertSame((Object)((Object)dialect), (Object)versionForFile.getLanguage());
        Assertions.assertEquals((Object)dialect.getDefaultVersion().getVersion(), (Object)versionForFile.getVersion());
    }
}

